/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorListenerNotifyFinishedJob;

public abstract class BaseInputProcessor<J>
implements InputProcessor<J> {
    private final Queue<J> jobsToDo_ = new ConcurrentLinkedQueue<J>();
    private final InputProcessorListenerNotifyFinishedJob<J> listener_;

    public BaseInputProcessor() {
        this(null);
    }

    public BaseInputProcessor(InputProcessorListenerNotifyFinishedJob<J> listener) {
        this.listener_ = listener;
    }

    @Override
    public void submit(J job) {
        this.jobsToDo_.add(job);
    }

    @Override
    public void process() throws InterruptedException {
        J nextJob;
        while (!this.isInterrupted() && (nextJob = this.jobsToDo_.poll()) != null) {
            this.process(nextJob);
            if (this.listener_ == null) continue;
            this.listener_.notifyFinished(nextJob);
        }
    }

    @Override
    public void finish() {
    }

    protected abstract boolean isInterrupted();

    protected abstract void process(J var1);
}

