/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.collections;

import java.util.concurrent.atomic.AtomicReference;

public class ActivationStack<E> {
    private final AtomicReference<Node<E>> top_ = new AtomicReference();
    private static Node<?> dummyNode = new Node<Object>(null);

    public boolean push(E element) {
        Node<E> oldHead;
        if (element == null) {
            throw new IllegalArgumentException("Elements in the stack cannot be null");
        }
        Node<E> newHead = new Node<E>(element);
        do {
            newHead.next = (oldHead = this.top_.get()) == null ? dummyNode : oldHead;
        } while (!this.top_.compareAndSet(oldHead, newHead));
        return oldHead == null;
    }

    public E peek() {
        Node<E> head = this.top_.get();
        if (head == null) {
            return null;
        }
        return (E)head.item;
    }

    public E pop() {
        Node newHead;
        Node<E> oldHead;
        do {
            if ((oldHead = this.top_.get()) != null) continue;
            return null;
        } while (!this.top_.compareAndSet(oldHead, newHead = oldHead.next));
        return (E)oldHead.item;
    }

    private static class Node<T> {
        public final T item;
        public Node<T> next;

        public Node(T item) {
            this.item = item;
        }
    }
}

