/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class TestInputProcessorFactory
extends SimpleInterrupter
implements InputProcessorFactory<Integer, Engene> {
    private final int seepInterval_;
    private final int sleepIntervalDelta_;
    private final Queue<Integer> todo_ = new ConcurrentLinkedQueue<Integer>();
    private final AtomicInteger aggregatedSum_ = new AtomicInteger(0);

    public TestInputProcessorFactory(int sleepInterval, int sleepIntervalDelta) {
        this.seepInterval_ = sleepInterval;
        this.sleepIntervalDelta_ = sleepIntervalDelta;
    }

    public Engene getEngine() {
        return new Engene();
    }

    public void finish() {
    }

    public int getSum() {
        return this.aggregatedSum_.get();
    }

    class Engene
    implements InputProcessor<Integer> {
        private int sum_ = 0;
        private final Random random = new Random();
        private int sleepCountdown_ = 0;

        Engene() {
        }

        public void submit(Integer job) {
            TestInputProcessorFactory.this.todo_.add(job);
        }

        public void process() throws InterruptedException {
            block0: while (!TestInputProcessorFactory.this.isInterrupted()) {
                Integer nextInput = (Integer)TestInputProcessorFactory.this.todo_.poll();
                if (nextInput == null) {
                    return;
                }
                this.sum_ += nextInput.intValue();
                this.sleepCountdown_ -= nextInput * TestInputProcessorFactory.this.sleepIntervalDelta_;
                while (true) {
                    if (this.sleepCountdown_ > 0) continue block0;
                    this.sleepCountdown_ += this.random.nextInt(TestInputProcessorFactory.this.seepInterval_) + 1;
                    Thread.sleep(1L);
                }
                break;
            }
            return;
        }

        public void finish() {
            TestInputProcessorFactory.this.aggregatedSum_.addAndGet(this.sum_);
            this.sum_ = 0;
            if (!TestInputProcessorFactory.this.isInterrupted() && !TestInputProcessorFactory.this.todo_.isEmpty()) {
                Assert.fail();
            }
        }
    }
}

