/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentComputation;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.TestInputProcessorFactory;

public class ConcurrentComputationTest {
    private static int MAX_INPUT = 100;
    private static int ROUNDS_ = 8;
    private final Random random = new Random();
    private TestInputProcessorFactory factory_;
    private ConcurrentComputation<Integer, ?> computation_;

    void setup(int round) {
        int workers = round + 1;
        ComputationExecutor executor = new ComputationExecutor(workers, "test-worker");
        this.factory_ = new TestInputProcessorFactory(MAX_INPUT, workers);
        this.computation_ = new ConcurrentComputation((InputProcessorFactory)this.factory_, executor, workers, workers);
    }

    @Test
    public void test() {
        int jobs = 1;
        for (int round = 0; round < ROUNDS_; ++round) {
            this.setup(round);
            jobs = 1 << this.random.nextInt(ROUNDS_);
            int sumExpected = 0;
            if (!this.computation_.start()) {
                Assert.fail();
            }
            int sleepCountdown = 0;
            try {
                for (int j = 0; j < jobs; ++j) {
                    int nextInput = this.random.nextInt(MAX_INPUT) + 1;
                    sumExpected += nextInput;
                    while (!this.computation_.submit((Object)nextInput)) {
                        if (!this.computation_.isInterrupted()) {
                            Assert.fail();
                        }
                        this.computation_.finish();
                        this.computation_.setInterrupt(false);
                        if (this.computation_.start()) continue;
                        Assert.fail();
                    }
                    sleepCountdown -= nextInput;
                    while (sleepCountdown <= 0) {
                        Thread.sleep(1L);
                        sleepCountdown += this.random.nextInt(MAX_INPUT) + 1;
                    }
                }
                while (true) {
                    this.computation_.finish();
                    if (this.computation_.isInterrupted()) {
                        this.computation_.setInterrupt(false);
                        if (this.computation_.start()) continue;
                        Assert.fail();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException fail) {
                Assert.fail();
            }
            Assert.assertEquals((long)sumExpected, (long)this.factory_.getSum());
        }
    }

    @Test
    public void testWithInterrupts() {
        Thread terminator = new Thread((Runnable)new Terminator(), "terminator");
        terminator.setDaemon(true);
        terminator.start();
        this.test();
    }

    class Terminator
    implements Runnable {
        Terminator() {
        }

        @Override
        public void run() {
            while (true) {
                ConcurrentComputation interrupter;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((interrupter = ConcurrentComputationTest.this.computation_) == null) continue;
                interrupter.setInterrupt(true);
            }
        }
    }
}

