/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.collections;

import java.util.Random;
import junit.framework.TestCase;
import org.semanticweb.elk.util.concurrent.collections.ActivationStack;

public class ActivationStackTest
extends TestCase {
    private static final int STACKS_COUNT_ = 1000;
    private static final int WORKER_COUNT_ = 10;
    private static final int ELEMENTS_COUNT_ = 1000000;
    private static final int ITERATIONS_ = 10000;
    final StackMonitor<Integer>[] stacks = new StackMonitor[1000];
    final ActivationStack<StackMonitor<Integer>> nonEmptyStacks = new ActivationStack();
    final Random generator = new Random(123L);

    public ActivationStackTest(String testName) {
        super(testName);
    }

    public void prepare() {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.stacks[i] = new StackMonitor();
        }
        for (i = 0; i < 1000000; ++i) {
            this.enqueue(i);
        }
    }

    public void enqueue(int element) {
        StackMonitor<Integer> monitor = this.stacks[this.generator.nextInt(1000)];
        if (monitor.stack.push((Object)element)) {
            monitor.checkActive();
            this.nonEmptyStacks.push(monitor);
        }
    }

    public void testStack() {
        this.prepare();
        Worker worker = new Worker();
        for (int i = 0; i < 10; ++i) {
            new Thread(worker).start();
        }
    }

    private static class StackMonitor<T> {
        final ActivationStack<T> stack = new ActivationStack();
        private volatile boolean islocked_ = false;

        public void lock() {
            this.checkActive();
            this.islocked_ = true;
        }

        public void unlock() {
            this.islocked_ = false;
        }

        public void checkActive() {
            if (this.islocked_) {
                TestCase.fail((String)"The stack is being accessed from two workers");
            }
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            StackMonitor monitor;
            for (int i = 0; i < 10000 && (monitor = (StackMonitor)ActivationStackTest.this.nonEmptyStacks.pop()) != null; ++i) {
                Integer element;
                while ((element = (Integer)monitor.stack.pop()) != null) {
                    monitor.lock();
                    ActivationStackTest.this.enqueue(element);
                    monitor.unlock();
                }
            }
        }
    }
}

