/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.semanticweb.elk.config.BaseConfiguration;
import org.semanticweb.elk.config.ConfigurationException;
import org.semanticweb.elk.io.IOUtils;

public class ConfigurationFactory {
    static final String STANDARD_RESOURCE_NAME = "elk";
    static final Logger LOGGER_ = Logger.getLogger(ConfigurationFactory.class);

    public BaseConfiguration getConfiguration(String prefix, Class<? extends BaseConfiguration> configClass) throws ConfigurationException {
        ResourceBundle bundle = null;
        BaseConfiguration config = ConfigurationFactory.instantiate(configClass);
        try {
            bundle = ResourceBundle.getBundle(STANDARD_RESOURCE_NAME, Locale.getDefault(), configClass.getClassLoader());
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (bundle == null) {
            LOGGER_.info((Object)("Loading default configuration parameters for " + configClass));
        } else {
            ConfigurationFactory.copyParameters(prefix, config, bundle);
        }
        return config;
    }

    public BaseConfiguration getConfiguration(InputStream source, String prefix, Class<? extends BaseConfiguration> configClass) throws ConfigurationException, IOException {
        PropertyResourceBundle bundle = new PropertyResourceBundle(source);
        BaseConfiguration config = ConfigurationFactory.instantiate(configClass);
        ConfigurationFactory.copyParameters(prefix, config, bundle);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(File configOnDisk, BaseConfiguration config) throws ConfigurationException, IOException {
        FileInputStream stream = null;
        BaseConfiguration loadedConfig = null;
        Properties diskProps = new Properties();
        try {
            stream = new FileInputStream(configOnDisk);
            loadedConfig = this.getConfiguration(stream, "", config.getClass());
            ConfigurationFactory.copyParameters(loadedConfig, diskProps);
        }
        catch (Throwable e) {
            try {
                LOGGER_.info((Object)"Overwriting configuration since it can't be loaded (perhaps doesn't exist?)");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
        ConfigurationFactory.copyParameters(config, diskProps);
        ConfigurationFactory.saveProperties(diskProps, configOnDisk);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveProperties(Properties diskProps, File configOnDisk) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(configOnDisk);
            diskProps.store(stream, "ELK parameters saved at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        }
        catch (FileNotFoundException e) {
            try {
                throw new ConfigurationException("Configuration cannot be saved because the destination file cannot be written", e);
                catch (IOException e2) {
                    throw new ConfigurationException("Configuration cannot be saved because the destination file cannot be written", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    private static void copyParameters(BaseConfiguration config, Properties diskProps) {
        for (String key : config.getParameterNames()) {
            diskProps.setProperty(key, config.getParameter(key));
        }
    }

    private static void copyParameters(String prefix, BaseConfiguration config, ResourceBundle bundle) {
        for (String key : bundle.keySet()) {
            if (!key.startsWith(prefix)) continue;
            config.setParameter(key, bundle.getString(key));
        }
    }

    private static BaseConfiguration instantiate(Class<? extends BaseConfiguration> configClass) throws ConfigurationException {
        BaseConfiguration config = null;
        try {
            config = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            config.initConfiguration();
            return config;
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to instantiate the configuration class " + configClass);
        }
    }
}

