/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LazyCollectionMinusSet<I>
extends AbstractCollection<I> {
    private final Collection<I> collection_;
    private final Set<I> set_;

    public LazyCollectionMinusSet(Collection<I> collection, Set<I> set) {
        this.collection_ = collection;
        this.set_ = set;
    }

    @Override
    public boolean isEmpty() {
        return this.set_.containsAll(this.collection_);
    }

    @Override
    public boolean contains(Object o) {
        return this.collection_.contains(o) && !this.set_.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<I> iterator() {
        return new Iterator<I>(){
            private final Iterator<I> iter_;
            private I next_;
            {
                this.iter_ = LazyCollectionMinusSet.this.collection_.iterator();
                this.next_ = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next_ == null && this.iter_.hasNext()) {
                    Object elem = this.iter_.next();
                    this.next_ = LazyCollectionMinusSet.this.set_.contains(elem) ? null : elem;
                }
                return this.next_ != null;
            }

            @Override
            public I next() {
                if (this.next_ != null) {
                    return this.giveAway();
                }
                if (this.hasNext()) {
                    return this.giveAway();
                }
                throw new NoSuchElementException();
            }

            private I giveAway() {
                Object elem = this.next_;
                this.next_ = null;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.collection_.size() - this.set_.size();
    }
}

