/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;

class PropertyInitializationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(PropertyInitializationStage.class);
    private int clearedSaturations_;
    private int progress_;
    private int maxProgress_;
    private Iterator<IndexedPropertyChain> todo_ = null;

    public PropertyInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Property Saturation Initialization";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.todo_ = this.reasoner.ontologyIndex.getIndexedPropertyChains().iterator();
        this.maxProgress_ = this.reasoner.ontologyIndex.getIndexedPropertyChains().size();
        this.progress_ = 0;
        this.clearedSaturations_ = 0;
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        while (true) {
            this.checkInterrupt();
            if (!this.todo_.hasNext()) break;
            IndexedPropertyChain ipc = this.todo_.next();
            SaturatedPropertyChain saturation = ipc.getSaturated();
            if (saturation != null) {
                saturation.clear();
                ++this.clearedSaturations_;
            }
            this.progressMonitor.report(++this.progress_, this.maxProgress_);
        }
    }

    @Override
    public boolean postExecute() {
        return super.postExecute();
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.todo_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.clearedSaturations_ > 0 && LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("Saturations cleared: " + this.clearedSaturations_);
        }
    }
}

