/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.AbstractStageExecutor;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.util.logging.Statistics;

public class LoggingStageExecutor
extends AbstractStageExecutor {
    protected static final Logger LOGGER_ = Logger.getLogger(LoggingStageExecutor.class);

    @Override
    public void execute(ReasonerStage stage) throws ElkException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug(stage.getName() + " stage:");
        }
        Statistics.logOperationStart(stage.getName(), LOGGER_);
        try {
            stage.preExecute();
            stage.execute();
            stage.printInfo();
            stage.postExecute();
            stage.dispose();
        }
        catch (ElkInterruptedException e) {
            LOGGER_.debug(stage.getName() + " was interrupted.");
            stage.printInfo();
            throw e;
        }
        finally {
            Statistics.logOperationFinish(stage.getName(), LOGGER_);
            Statistics.logMemoryUsage(LOGGER_);
        }
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug(stage.getName() + ": done.");
        }
    }
}

