/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectComplementOfVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.semanticweb.elk.util.logging.ElkMessage;

public class IndexedObjectComplementOf
extends IndexedClassExpression {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedObjectComplementOf.class);
    private final IndexedClassExpression negated_;

    protected IndexedObjectComplementOf(IndexedClassExpression negated) {
        this.negated_ = negated;
    }

    public IndexedClassExpression getNegated() {
        return this.negated_;
    }

    public <O> O accept(IndexedObjectComplementOfVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassExpressionVisitor<O> visitor) {
        return this.accept((IndexedObjectComplementOfVisitor<O>)visitor);
    }

    @Override
    void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        if (this.positiveOccurrenceNo == 0 && positiveIncrement > 0) {
            index.add(this.negated_, new ThisCompositionRule(this));
        }
        if (this.negativeOccurrenceNo == 0 && negativeIncrement > 0 && LOGGER_.isEnabledFor(Level.WARN)) {
            LOGGER_.warn(ElkMessage.serialize("reasoner.indexing.IndexedObjectComplementOf", "ELK does not support negative occurrences of ObjectComplementOf. Reasoning might be incomplete!"));
        }
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
        this.checkOccurrenceNumbers();
        if (this.positiveOccurrenceNo == 0 && positiveIncrement < 0) {
            index.remove(this.negated_, new ThisCompositionRule(this));
        }
    }

    @Override
    public void accept(DecompositionRuleApplicationVisitor visitor, Context context) {
        visitor.visit(this, context);
    }

    @Override
    public String toStringStructural() {
        return "ObjectComplementOf(" + this.negated_ + ')';
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        private static final String NAME = "ObjectComplementOf Clash";
        private IndexedClassExpression negation_;
        private static final Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher<ChainableRule<Context>, ThisCompositionRule>(ThisCompositionRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            @Override
            public ThisCompositionRule create(ChainableRule<Context> tail) {
                return new ThisCompositionRule(tail);
            }
        };

        private ThisCompositionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisCompositionRule(IndexedClassExpression complement) {
            this((ChainableRule<Context>)null);
            this.negation_ = complement;
        }

        @Override
        public String getName() {
            return NAME;
        }

        public IndexedClassExpression getNegation() {
            return this.negation_;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("Applying ObjectComplementOf Clash to " + context);
            }
            if (this.negation_ != null && context.getSubsumers().contains(this.negation_)) {
                writer.produce(context, Contradiction.getInstance());
            }
        }

        @Override
        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.getCreate(MATCHER_, FACTORY_);
            boolean changed = false;
            if (this.negation_ != null && rule.negation_ != this.negation_) {
                if (rule.negation_ != null) {
                    throw new ElkUnexpectedIndexingException(this.getName() + " complement value " + rule.negation_ + " cannot be overwritten with " + this.negation_);
                }
                rule.negation_ = this.negation_;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.find(MATCHER_);
            boolean changed = false;
            if (rule != null) {
                if (this.negation_ != null && rule.negation_ == this.negation_) {
                    rule.negation_ = null;
                    changed = true;
                }
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                }
            }
            return changed;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        private boolean isEmpty() {
            return this.negation_ == null;
        }
    }
}

