/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.AnonymousNode;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.FreshTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public class Reasoner
extends AbstractReasonerState {
    private static final Logger LOGGER_ = Logger.getLogger(Reasoner.class);
    protected ProgressMonitor progressMonitor;
    private final ReasonerStageExecutor stageExecutor_;
    private volatile ComputationExecutor executor_;
    private int workerNo_;
    private ElkObjectFactory elkFactory = new ElkObjectFactoryImpl();
    protected boolean allowFreshEntities;

    protected Reasoner(AxiomLoader axiomLoader, ReasonerStageExecutor stageExecutor, ExecutorService executor) {
        super(axiomLoader);
        this.stageExecutor_ = stageExecutor;
        this.progressMonitor = new DummyProgressMonitor();
        this.allowFreshEntities = true;
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info("ELK reasoner was created");
        }
    }

    public synchronized void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public synchronized void setAllowFreshEntities(boolean allow) {
        this.allowFreshEntities = allow;
    }

    public synchronized boolean getAllowFreshEntities() {
        return this.allowFreshEntities;
    }

    @Override
    protected int getNumberOfWorkers() {
        return this.workerNo_;
    }

    public synchronized void setNumberOfWorkers(int workerNo) {
        this.workerNo_ = workerNo;
    }

    public synchronized void setConfigurationOptions(ReasonerConfiguration config) {
        int newWorkerNo = config.getParameterAsInt("elk.reasoner.number_of_workers");
        this.setAllowIncrementalMode(config.getParameterAsBoolean("elk.reasoner.incremental.allowed"));
        this.setAllowIncrementalTaxonomy(config.getParameterAsBoolean("elk.reasoner.incremental.taxonomy"));
        if (newWorkerNo > this.workerNo_) {
            this.executor_ = null;
        }
        this.workerNo_ = newWorkerNo;
    }

    @Override
    protected ComputationExecutor getProcessExecutor() {
        if (this.executor_ == null) {
            this.executor_ = new ComputationExecutor(this.workerNo_, "elk-reasoner");
        }
        return this.executor_;
    }

    @Override
    protected ReasonerStageExecutor getStageExecutor() {
        return this.stageExecutor_;
    }

    @Override
    protected ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.stageExecutor_.dispose();
        if (this.executor_ == null) {
            return true;
        }
        this.executor_.shutdown();
        this.executor_.awaitTermination(timeout, unit);
        boolean success = this.executor_.isShutdown();
        this.executor_ = null;
        if (success) {
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info("ELK reasoner has shut down");
            }
        } else {
            LOGGER_.error("ELK reasoner failed to shut down!");
        }
        return success;
    }

    public synchronized boolean shutdown() throws InterruptedException {
        return this.shutdown(1L, TimeUnit.MINUTES);
    }

    protected TaxonomyNode<ElkClass> getTaxonomyNode(ElkClass elkClass) throws ElkException {
        TaxonomyNode<ElkClass> node = this.getTaxonomy().getNode(elkClass);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshTaxonomyNode<ElkClass>(elkClass, this.getTaxonomy());
        }
        throw new ElkFreshEntitiesException(elkClass);
    }

    protected InstanceNode<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual elkNamedIndividual) throws ElkException {
        InstanceNode<ElkClass, ElkNamedIndividual> node = this.getInstanceTaxonomy().getInstanceNode(elkNamedIndividual);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshInstanceNode<ElkClass, ElkNamedIndividual>(elkNamedIndividual, this.getInstanceTaxonomy());
        }
        throw new ElkFreshEntitiesException(elkNamedIndividual);
    }

    protected TypeNode<ElkClass, ElkNamedIndividual> getTypeNode(ElkClass elkClass) throws ElkException {
        TypeNode<ElkClass, ElkNamedIndividual> node = this.getInstanceTaxonomy().getTypeNode(elkClass);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshTypeNode<ElkClass, ElkNamedIndividual>(elkClass, this.getInstanceTaxonomy());
        }
        throw new ElkFreshEntitiesException(elkClass);
    }

    public synchronized TaxonomyNode<ElkClass> getClassNode(ElkClassExpression classExpression) throws ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression);
        }
        ElkClass queryClass = this.elkFactory.getClass(new ElkFullIri(OwlFunctionalStylePrinter.toString(classExpression)));
        ElkEquivalentClassesAxiom materializedQuery = this.elkFactory.getEquivalentClassesAxiom(queryClass, classExpression, new ElkClassExpression[0]);
        return this.getQueryTaxonomyNode(queryClass, materializedQuery);
    }

    public synchronized Node<ElkClass> getEquivalentClasses(ElkClassExpression classExpression) throws ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression);
        }
        ElkClass queryClass = this.elkFactory.getClass(new ElkFullIri(OwlFunctionalStylePrinter.toString(classExpression)));
        ElkEquivalentClassesAxiom materializedQuery = this.elkFactory.getEquivalentClassesAxiom(queryClass, classExpression, new ElkClassExpression[0]);
        TaxonomyNode<ElkClass> queryNode = this.getQueryTaxonomyNode(queryClass, materializedQuery);
        return new AnonymousNode<ElkClass>(queryClass, queryNode.getMembers(), Comparators.ELK_CLASS_COMPARATOR);
    }

    public synchronized Set<? extends Node<ElkClass>> getSubClasses(ElkClassExpression classExpression, boolean direct) throws ElkException {
        TaxonomyNode<ElkClass> queryNode = this.getClassNode(classExpression);
        return direct ? queryNode.getDirectSubNodes() : queryNode.getAllSubNodes();
    }

    public synchronized Set<? extends Node<ElkClass>> getSuperClasses(ElkClassExpression classExpression, boolean direct) throws ElkException {
        TaxonomyNode<ElkClass> queryNode = this.getClassNode(classExpression);
        return direct ? queryNode.getDirectSuperNodes() : queryNode.getAllSuperNodes();
    }

    public synchronized Set<? extends Node<ElkNamedIndividual>> getInstances(ElkClassExpression classExpression, boolean direct) throws ElkException {
        TypeNode<ElkClass, ElkNamedIndividual> queryNode;
        if (classExpression instanceof ElkClass) {
            queryNode = this.getTypeNode((ElkClass)classExpression);
        } else {
            ElkClass queryClass = this.elkFactory.getClass(new ElkFullIri(OwlFunctionalStylePrinter.toString(classExpression)));
            ElkSubClassOfAxiom materializedQuery = this.elkFactory.getSubClassOfAxiom(classExpression, queryClass);
            queryNode = this.getQueryTypeNode(queryClass, materializedQuery);
        }
        return direct ? queryNode.getDirectInstanceNodes() : queryNode.getAllInstanceNodes();
    }

    public synchronized Set<? extends Node<ElkClass>> getTypes(ElkNamedIndividual elkNamedIndividual, boolean direct) throws ElkException {
        InstanceNode<ElkClass, ElkNamedIndividual> node = this.getInstanceNode(elkNamedIndividual);
        return direct ? node.getDirectTypeNodes() : node.getAllTypeNodes();
    }

    public synchronized boolean isSatisfiable(ElkClassExpression classExpression) throws ElkException {
        Node<ElkClass> queryNode;
        if (classExpression instanceof ElkClass) {
            queryNode = this.getClassNode(classExpression);
        } else {
            ElkClass queryClass = this.elkFactory.getClass(new ElkFullIri(OwlFunctionalStylePrinter.toString(classExpression)));
            ElkSubClassOfAxiom materializedQuery = this.elkFactory.getSubClassOfAxiom(queryClass, classExpression);
            queryNode = this.getQueryNode(queryClass, materializedQuery);
        }
        return !queryNode.getMembers().contains(PredefinedElkClass.OWL_NOTHING);
    }

    static AxiomLoader getQueryLoader(final ElkAxiom materializedQuery, final boolean addition) {
        return new AbstractAxiomLoader(){
            boolean finished = false;

            @Override
            public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
                (addition ? axiomInserter : axiomDeleter).visit(materializedQuery);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((addition ? "adding materialized quiery axiom: " : "removing materialized quiery axiom: ") + OwlFunctionalStylePrinter.toString(materializedQuery));
                }
                this.finished = true;
            }

            @Override
            public boolean isLoadingFinished() {
                return this.finished;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node<ElkClass> getQueryNode(ElkClass queryClass, ElkAxiom materializedQuery) throws ElkException {
        boolean oldIsAllowIncrementalMode = this.isAllowIncrementalMode();
        this.setAllowIncrementalMode(true);
        this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, true));
        try {
            TaxonomyNode<ElkClass> taxonomyNode = this.getClassNode(queryClass);
            return taxonomyNode;
        }
        finally {
            this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, false));
            this.setAllowIncrementalMode(oldIsAllowIncrementalMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeNode<ElkClass, ElkNamedIndividual> getQueryTypeNode(ElkClass queryClass, ElkAxiom materializedQuery) throws ElkException {
        boolean oldIsAllowIncrementalMode = this.isAllowIncrementalMode();
        this.setAllowIncrementalMode(true);
        this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, true));
        try {
            TypeNode<ElkClass, ElkNamedIndividual> typeNode = this.getTypeNode(queryClass);
            return typeNode;
        }
        finally {
            this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, false));
            this.setAllowIncrementalMode(oldIsAllowIncrementalMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaxonomyNode<ElkClass> getQueryTaxonomyNode(ElkClass queryClass, ElkAxiom materializedQuery) throws ElkException {
        boolean oldIsAllowIncrementalMode = this.isAllowIncrementalMode();
        this.setAllowIncrementalMode(true);
        this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, true));
        try {
            TaxonomyNode<ElkClass> taxonomyNode = this.getTaxonomyNode(queryClass);
            return taxonomyNode;
        }
        finally {
            this.registerAxiomLoader(Reasoner.getQueryLoader(materializedQuery, false));
            this.setAllowIncrementalMode(oldIsAllowIncrementalMode);
        }
    }
}

