/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableBottomNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class TaxonomyNodeUtils {
    private static <T extends ElkObject, O extends TaxonomyNode<T>> Set<O> getAllReachable(Collection<? extends O> direct, GetSuccessors<T, O> succ) {
        ArrayHashSet result = new ArrayHashSet(direct.size());
        LinkedList<Object> todo = new LinkedList<Object>();
        todo.addAll(direct);
        while (!todo.isEmpty()) {
            TaxonomyNode next = (TaxonomyNode)todo.poll();
            if (!result.add(next)) continue;
            for (TaxonomyNode nextSuperNode : succ.get(next)) {
                todo.add(nextSuperNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static <T extends ElkObject> Set<? extends TaxonomyNode<T>> getAllSuperNodes(TaxonomyNode<T> node) {
        return TaxonomyNodeUtils.getAllReachable(node.getDirectSuperNodes(), new GetSuccessors<T, TaxonomyNode<T>>(){

            @Override
            public Set<? extends TaxonomyNode<T>> get(TaxonomyNode<T> node) {
                return node.getDirectSuperNodes();
            }
        });
    }

    public static <T extends ElkObject> Set<? extends TaxonomyNode<T>> getAllSubNodes(TaxonomyNode<T> node) {
        return TaxonomyNodeUtils.getAllReachable(node.getDirectSubNodes(), new GetSuccessors<T, TaxonomyNode<T>>(){

            @Override
            public Set<? extends TaxonomyNode<T>> get(TaxonomyNode<T> node) {
                return node.getDirectSubNodes();
            }
        });
    }

    public static <T extends ElkObject> Set<? extends UpdateableTaxonomyNode<T>> getAllUpdateableSubNodes(UpdateableTaxonomyNode<T> node) {
        return TaxonomyNodeUtils.getAllReachable(node.getDirectUpdateableSubNodes(), new GetSuccessors<T, UpdateableTaxonomyNode<T>>(){

            @Override
            public Set<? extends UpdateableTaxonomyNode<T>> get(UpdateableTaxonomyNode<T> node) {
                return node.getDirectUpdateableSubNodes();
            }
        });
    }

    public static <T extends ElkObject> Set<? extends TaxonomyNode<T>> getAllUpdateableSuperNodes(UpdateableTaxonomyNode<T> node) {
        return TaxonomyNodeUtils.getAllReachable(node.getDirectUpdateableSuperNodes(), new GetSuccessors<T, UpdateableTaxonomyNode<T>>(){

            @Override
            public Set<? extends UpdateableTaxonomyNode<T>> get(UpdateableTaxonomyNode<T> node) {
                return node.getDirectUpdateableSuperNodes();
            }
        });
    }

    public static <T extends ElkObject> Set<? extends UpdateableTaxonomyNode<T>> getAllUpdateableSuperNodes(UpdateableBottomNode<T> node) {
        return TaxonomyNodeUtils.getAllReachable(node.getDirectUpdateableSuperNodes(), new GetSuccessors<T, UpdateableTaxonomyNode<T>>(){

            @Override
            public Set<? extends UpdateableTaxonomyNode<T>> get(UpdateableTaxonomyNode<T> node) {
                return node.getDirectUpdateableSuperNodes();
            }
        });
    }

    static interface GetSuccessors<T extends ElkObject, O extends TaxonomyNode<T>> {
        public Set<? extends O> get(O var1);
    }
}

