/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.predefined.PredefinedElkIri;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class TaxonomyPrinter {
    protected static Comparator<ElkClass> CLASS_COMPARATOR = Comparators.ELK_CLASS_COMPARATOR;
    protected static Comparator<ElkNamedIndividual> INDIVIDUAL_COMPARATOR = Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR;

    public static void dumpClassTaxomomyToFile(Taxonomy<ElkClass> taxonomy, String fileName, boolean addHash) throws IOException {
        FileWriter fstream = new FileWriter(fileName);
        BufferedWriter writer = new BufferedWriter(fstream);
        TaxonomyPrinter.dumpClassTaxomomy(taxonomy, writer, addHash);
        writer.close();
    }

    public static void dumpClassTaxomomy(Taxonomy<ElkClass> taxonomy, Writer writer, boolean addHash) throws IOException {
        writer.append("Ontology(\n");
        TaxonomyPrinter.processTaxomomy(taxonomy, writer);
        writer.append(")\n");
        if (addHash) {
            writer.append("\n# Hash code: " + TaxonomyPrinter.getHashString(taxonomy) + "\n");
        }
        writer.flush();
    }

    public static void dumpInstanceTaxomomyToFile(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy, String fileName, boolean addHash) throws IOException {
        FileWriter fstream = new FileWriter(fileName);
        BufferedWriter writer = new BufferedWriter(fstream);
        TaxonomyPrinter.dumpInstanceTaxomomy(taxonomy, writer, addHash);
        writer.close();
    }

    public static void dumpInstanceTaxomomy(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy, Writer writer, boolean addHash) throws IOException {
        writer.write("Ontology(\n");
        TaxonomyPrinter.processInstanceTaxomomy(taxonomy, writer);
        writer.write(")\n");
        if (addHash) {
            writer.write("\n# Hash code: " + TaxonomyPrinter.getInstanceHashString(taxonomy) + "\n");
        }
    }

    public static String getHashString(Taxonomy<ElkClass> taxonomy) {
        return Integer.toHexString(TaxonomyHasher.hash(taxonomy));
    }

    public static String getInstanceHashString(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) {
        return Integer.toHexString(InstanceTaxonomyHasher.hash(taxonomy));
    }

    protected static void processTaxomomy(Taxonomy<ElkClass> classTaxonomy, Appendable writer) throws IOException {
        ElkObjectFactoryImpl objectFactory = new ElkObjectFactoryImpl();
        TaxonomyPrinter.printDeclarations(classTaxonomy, (ElkObjectFactory)objectFactory, writer);
        TreeSet<ElkClass> canonicalElkClasses = new TreeSet<ElkClass>(CLASS_COMPARATOR);
        for (TaxonomyNode<ElkClass> classNode : classTaxonomy.getNodes()) {
            canonicalElkClasses.add((ElkClass)classNode.getCanonicalMember());
        }
        for (ElkClass elkClass : canonicalElkClasses) {
            TaxonomyNode<ElkClass> classNode = classTaxonomy.getNode(elkClass);
            ArrayList<ElkClass> orderedEquivalentClasses = new ArrayList<ElkClass>(classNode.getMembers());
            Collections.sort(orderedEquivalentClasses, CLASS_COMPARATOR);
            TreeSet<ElkClass> orderedSubClasses = new TreeSet<ElkClass>(CLASS_COMPARATOR);
            for (TaxonomyNode<ElkClass> childNode : classNode.getDirectSubNodes()) {
                orderedSubClasses.add((ElkClass)childNode.getCanonicalMember());
            }
            TaxonomyPrinter.printClassAxioms(elkClass, orderedEquivalentClasses, orderedSubClasses, writer);
        }
    }

    protected static void printDeclarations(Taxonomy<ElkClass> classTaxonomy, ElkObjectFactory objectFactory, Appendable writer) throws IOException {
        ArrayList<ElkClass> classes = new ArrayList<ElkClass>(classTaxonomy.getNodes().size() * 2);
        for (TaxonomyNode<ElkClass> classNode : classTaxonomy.getNodes()) {
            for (ElkClass clazz : classNode.getMembers()) {
                if (clazz.getIri().equals((Object)PredefinedElkIri.OWL_THING.get()) || clazz.getIri().equals((Object)PredefinedElkIri.OWL_NOTHING.get())) continue;
                classes.add(clazz);
            }
        }
        Collections.sort(classes, CLASS_COMPARATOR);
        for (ElkClass clazz : classes) {
            ElkDeclarationAxiom decl = objectFactory.getDeclarationAxiom((ElkEntity)clazz);
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)decl, (boolean)true);
            writer.append('\n');
        }
    }

    protected static void printIndividualDeclarations(Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> individualNodes, ElkObjectFactory objectFactory, Writer writer) throws IOException {
        for (InstanceNode<ElkClass, ElkNamedIndividual> instanceNode : individualNodes) {
            for (ElkNamedIndividual individual : instanceNode.getMembers()) {
                ElkDeclarationAxiom decl = objectFactory.getDeclarationAxiom((ElkEntity)individual);
                OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)decl, (boolean)true);
                writer.append('\n');
            }
        }
    }

    protected static void printClassAxioms(ElkClass elkClass, ArrayList<ElkClass> orderedEquivalentClasses, TreeSet<ElkClass> orderedSubClasses, Appendable writer) throws IOException {
        ElkObjectFactoryImpl objectFactory = new ElkObjectFactoryImpl();
        if (orderedEquivalentClasses.size() > 1) {
            ElkEquivalentClassesAxiom elkEquivalentClassesAxiom = objectFactory.getEquivalentClassesAxiom(orderedEquivalentClasses);
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)elkEquivalentClassesAxiom, (boolean)true);
            writer.append('\n');
        }
        if (!elkClass.getIri().equals((Object)PredefinedElkIri.OWL_THING.get())) {
            for (ElkClass elkSubClass : orderedSubClasses) {
                if (elkSubClass.getIri().equals((Object)PredefinedElkIri.OWL_NOTHING.get())) continue;
                ElkSubClassOfAxiom elkSubClassAxiom = objectFactory.getSubClassOfAxiom((ElkClassExpression)elkSubClass, (ElkClassExpression)elkClass);
                OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)elkSubClassAxiom, (boolean)true);
                writer.append('\n');
            }
        }
    }

    protected static void printIndividualAxioms(ElkNamedIndividual individual, ArrayList<ElkNamedIndividual> orderedSameIndividuals, TreeSet<ElkClass> orderedDirectClasses, ElkObjectFactory objectFactory, Writer writer) throws IOException {
        if (orderedSameIndividuals.size() > 1) {
            ElkSameIndividualAxiom axiom = objectFactory.getSameIndividualAxiom(orderedSameIndividuals);
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)axiom, (boolean)true);
            writer.append('\n');
        }
        for (ElkClass clazz : orderedDirectClasses) {
            if (clazz.getIri().equals((Object)PredefinedElkIri.OWL_THING.get())) continue;
            ElkClassAssertionAxiom axiom = objectFactory.getClassAssertionAxiom((ElkClassExpression)clazz, (ElkIndividual)individual);
            OwlFunctionalStylePrinter.append((Appendable)writer, (ElkObject)axiom, (boolean)true);
            writer.append('\n');
        }
    }

    protected static void processInstanceTaxomomy(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy, Writer writer) throws IOException {
        ElkObjectFactoryImpl objectFactory = new ElkObjectFactoryImpl();
        TaxonomyPrinter.printIndividualDeclarations(taxonomy.getInstanceNodes(), (ElkObjectFactory)objectFactory, writer);
        TaxonomyPrinter.processTaxomomy(taxonomy, writer);
        TreeSet<ElkNamedIndividual> canonicalIndividuals = new TreeSet<ElkNamedIndividual>(INDIVIDUAL_COMPARATOR);
        for (InstanceNode<ElkClass, ElkNamedIndividual> node : taxonomy.getInstanceNodes()) {
            canonicalIndividuals.add((ElkNamedIndividual)node.getCanonicalMember());
        }
        for (ElkNamedIndividual individual : canonicalIndividuals) {
            InstanceNode<ElkClass, ElkNamedIndividual> node = taxonomy.getInstanceNode(individual);
            ArrayList<ElkNamedIndividual> orderedSameIndividuals = new ArrayList<ElkNamedIndividual>(node.getMembers());
            Collections.sort(orderedSameIndividuals, INDIVIDUAL_COMPARATOR);
            TreeSet<ElkClass> orderedTypes = new TreeSet<ElkClass>(CLASS_COMPARATOR);
            for (TaxonomyNode taxonomyNode : node.getDirectTypeNodes()) {
                orderedTypes.add((ElkClass)taxonomyNode.getCanonicalMember());
            }
            TaxonomyPrinter.printIndividualAxioms(individual, orderedSameIndividuals, orderedTypes, (ElkObjectFactory)objectFactory, writer);
        }
    }
}

