/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionFactory;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutput;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTypeNode;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;

public class InstanceTaxonomyComputationFactory
implements InputProcessorFactory<IndexedIndividual, Engine> {
    private final UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy_;
    private final TransitiveReductionFactory<IndexedIndividual, TransitiveReductionJob<IndexedIndividual>> transitiveReductionShared_;
    private final TransitiveReductionOutputProcessor outputProcessor_;

    public InstanceTaxonomyComputationFactory(SaturationState saturationState, int maxWorkers, UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> partialTaxonomy) {
        this.taxonomy_ = partialTaxonomy;
        this.transitiveReductionShared_ = new TransitiveReductionFactory(saturationState, maxWorkers, new ThisTransitiveReductionListener());
        this.outputProcessor_ = new TransitiveReductionOutputProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignDirectTypeNode(UpdateableInstanceNode<ElkClass, ElkNamedIndividual> instanceNode, UpdateableTypeNode<ElkClass, ElkNamedIndividual> typeNode) {
        instanceNode.addDirectTypeNode(typeNode);
        UpdateableTypeNode<ElkClass, ElkNamedIndividual> updateableTypeNode = typeNode;
        synchronized (updateableTypeNode) {
            typeNode.addDirectInstanceNode(instanceNode);
        }
    }

    public UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
        return this.taxonomy_;
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void setInterrupt(boolean flag) {
        this.transitiveReductionShared_.setInterrupt(flag);
    }

    public boolean isInterrupted() {
        return this.transitiveReductionShared_.isInterrupted();
    }

    public void finish() {
        this.transitiveReductionShared_.finish();
    }

    public void printStatistics() {
        this.transitiveReductionShared_.printStatistics();
    }

    public class Engine
    implements InputProcessor<IndexedIndividual> {
        protected final TransitiveReductionFactory.Engine transitiveReductionEngine;

        private Engine() {
            this.transitiveReductionEngine = InstanceTaxonomyComputationFactory.this.transitiveReductionShared_.getEngine();
        }

        public final void submit(IndexedIndividual job) {
            this.transitiveReductionEngine.submit(new TransitiveReductionJob<IndexedIndividual>(job));
        }

        public final void process() throws InterruptedException {
            this.transitiveReductionEngine.process();
        }

        public void finish() {
            this.transitiveReductionEngine.finish();
        }
    }

    private class TransitiveReductionOutputProcessor
    implements TransitiveReductionOutputVisitor<IndexedIndividual> {
        private TransitiveReductionOutputProcessor() {
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedIndividual> output) {
            UpdateableInstanceNode node = InstanceTaxonomyComputationFactory.this.taxonomy_.getCreateInstanceNode(Collections.singleton(((IndexedIndividual)output.getRoot()).getElkNamedIndividual()));
            for (TransitiveReductionOutputEquivalent<IndexedClass> directSuperEquivalent : output.getDirectSubsumers()) {
                UpdateableTypeNode superNode = InstanceTaxonomyComputationFactory.this.taxonomy_.getCreateTypeNode(directSuperEquivalent.getEquivalent());
                InstanceTaxonomyComputationFactory.assignDirectTypeNode(node, superNode);
            }
            node.trySetModified(false);
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedIndividual> output) {
            throw new IllegalArgumentException();
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedIndividual> output) {
            throw new IllegalArgumentException();
        }
    }

    private class ThisTransitiveReductionListener
    implements TransitiveReductionListener<TransitiveReductionJob<IndexedIndividual>> {
        private ThisTransitiveReductionListener() {
        }

        public void notifyFinished(TransitiveReductionJob<IndexedIndividual> job) throws InterruptedException {
            ((TransitiveReductionOutput)job.getOutput()).accept(InstanceTaxonomyComputationFactory.this.outputProcessor_);
        }
    }
}

