/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionFactory;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionJob;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionListener;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutput;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalent;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputEquivalentDirect;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputUnsatisfiable;
import org.semanticweb.elk.reasoner.reduction.TransitiveReductionOutputVisitor;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public class ClassTaxonomyComputationFactory
extends SimpleInterrupter
implements InputProcessorFactory<Collection<IndexedClass>, Engine> {
    private static final Logger LOGGER_ = Logger.getLogger(ClassTaxonomyComputationFactory.class);
    private final UpdateableTaxonomy<ElkClass> taxonomy_;
    private final TransitiveReductionFactory<IndexedClass, TransitiveReductionJob<IndexedClass>> transitiveReductionShared_;
    private final TransitiveReductionOutputProcessor outputProcessor_;

    public ClassTaxonomyComputationFactory(SaturationState saturationState, int maxWorkers, UpdateableTaxonomy<ElkClass> partialTaxonomy) {
        this.taxonomy_ = partialTaxonomy;
        this.transitiveReductionShared_ = new TransitiveReductionFactory(saturationState, maxWorkers, new ThisTransitiveReductionListener());
        this.outputProcessor_ = new TransitiveReductionOutputProcessor();
    }

    public ClassTaxonomyComputationFactory(SaturationState saturationState, int maxWorkers) {
        this(saturationState, maxWorkers, new ConcurrentClassTaxonomy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignDirectSuperClassNode(UpdateableTaxonomyNode<ElkClass> subNode, UpdateableTaxonomyNode<ElkClass> superNode) {
        subNode.addDirectSuperNode(superNode);
        UpdateableTaxonomyNode<ElkClass> updateableTaxonomyNode = superNode;
        synchronized (updateableTaxonomyNode) {
            superNode.addDirectSubNode(subNode);
        }
    }

    public UpdateableTaxonomy<ElkClass> getTaxonomy() {
        return this.taxonomy_;
    }

    public Engine getEngine() {
        return new Engine();
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.transitiveReductionShared_.setInterrupt(flag);
    }

    public void finish() {
        this.transitiveReductionShared_.finish();
    }

    public void printStatistics() {
        this.transitiveReductionShared_.printStatistics();
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return this.transitiveReductionShared_.getRuleAndConclusionStatistics();
    }

    public class Engine
    implements InputProcessor<Collection<IndexedClass>> {
        protected final TransitiveReductionFactory.Engine transitiveReductionEngine;

        private Engine() {
            this.transitiveReductionEngine = ClassTaxonomyComputationFactory.this.transitiveReductionShared_.getEngine();
        }

        public final void submit(Collection<IndexedClass> input) {
            for (IndexedClass ic : input) {
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(ic + ": taxonomy construction started"));
                }
                this.transitiveReductionEngine.submit(new TransitiveReductionJob<IndexedClass>(ic));
            }
        }

        public final void process() throws InterruptedException {
            this.transitiveReductionEngine.process();
        }

        public void finish() {
            this.transitiveReductionEngine.finish();
        }
    }

    private class TransitiveReductionOutputProcessor
    implements TransitiveReductionOutputVisitor<IndexedClass> {
        private TransitiveReductionOutputProcessor() {
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalentDirect<IndexedClass> output) {
            UpdateableTaxonomyNode<ElkClass> node = ClassTaxonomyComputationFactory.this.taxonomy_.getCreateNode(output.getEquivalent());
            for (TransitiveReductionOutputEquivalent<IndexedClass> directSuperEquivalent : output.getDirectSubsumers()) {
                UpdateableTaxonomyNode<ElkClass> superNode = ClassTaxonomyComputationFactory.this.taxonomy_.getCreateNode(directSuperEquivalent.getEquivalent());
                ClassTaxonomyComputationFactory.assignDirectSuperClassNode(node, superNode);
            }
            node.trySetModified(false);
        }

        @Override
        public void visit(TransitiveReductionOutputUnsatisfiable<IndexedClass> output) {
            ClassTaxonomyComputationFactory.this.taxonomy_.addToBottomNode(((IndexedClass)output.getRoot()).getElkClass());
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(output.getRoot() + ": added to the bottom node"));
            }
        }

        @Override
        public void visit(TransitiveReductionOutputEquivalent<IndexedClass> output) {
            throw new IllegalArgumentException();
        }
    }

    private class ThisTransitiveReductionListener
    implements TransitiveReductionListener<TransitiveReductionJob<IndexedClass>> {
        private ThisTransitiveReductionListener() {
        }

        public void notifyFinished(TransitiveReductionJob<IndexedClass> job) throws InterruptedException {
            ((TransitiveReductionOutput)job.getOutput()).accept(ClassTaxonomyComputationFactory.this.outputProcessor_);
        }
    }
}

