/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.InstanceTaxonomyComputation;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;

public class IncrementalInstanceTaxonomyComputationStage
extends AbstractReasonerStage {
    private InstanceTaxonomyComputation computation_ = null;

    public IncrementalInstanceTaxonomyComputationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Incremental Instance Taxonomy Computation";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        Set<ElkNamedIndividual> modifiedIndividuals = this.reasoner.instanceTaxonomyState.getModifiedIndividuals();
        Operations.Transformation<ElkNamedIndividual, IndexedIndividual> transformation = new Operations.Transformation<ElkNamedIndividual, IndexedIndividual>(){

            public IndexedIndividual transform(ElkNamedIndividual element) {
                IndexedIndividual indexedindividual = (IndexedIndividual)element.accept((ElkIndividualVisitor)IncrementalInstanceTaxonomyComputationStage.this.reasoner.objectCache_.getIndexObjectConverter());
                return indexedindividual.occurs() ? indexedindividual : null;
            }
        };
        Collection modified = Operations.getCollection((Iterable)Operations.map(modifiedIndividuals, (Operations.Transformation)transformation), (int)modifiedIndividuals.size());
        this.computation_ = new InstanceTaxonomyComputation(modified, this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.saturationState, this.reasoner.instanceTaxonomyState.getTaxonomy());
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.instanceTaxonomyState.getWriter().clearModifiedIndividuals();
        this.reasoner.ontologyIndex.initIndividualSignatureChanges();
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt((Interrupter)this.computation_, flag);
    }
}

