/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationCounter;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationTimer;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationCounter;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationTimer;

public class RuleStatistics {
    public final RuleApplicationCounter ruleCounter = new RuleApplicationCounter();
    public final RuleApplicationTimer ruleTimer = new RuleApplicationTimer();
    public final DecompositionRuleApplicationCounter decompositionRuleCounter = new DecompositionRuleApplicationCounter();
    public final DecompositionRuleApplicationTimer decompositionRuleTimer = new DecompositionRuleApplicationTimer();
    private int numOfMeasurements_ = 0;

    public void startMeasurements() {
        if (this.numOfMeasurements_ < 1) {
            this.numOfMeasurements_ = 1;
        }
    }

    private boolean measurementsTaken() {
        return this.numOfMeasurements_ > 0;
    }

    public void reset() {
        this.decompositionRuleCounter.reset();
        this.decompositionRuleTimer.reset();
        this.ruleCounter.reset();
        this.ruleTimer.reset();
        this.numOfMeasurements_ = 0;
    }

    public synchronized void add(RuleStatistics stats) {
        if (stats.measurementsTaken()) {
            this.numOfMeasurements_ += stats.numOfMeasurements_;
            this.decompositionRuleCounter.add(stats.decompositionRuleCounter);
            this.decompositionRuleTimer.add(stats.decompositionRuleTimer);
            this.ruleCounter.add(stats.ruleCounter);
            this.ruleTimer.add(stats.ruleTimer);
        }
    }

    public void print(Logger logger) {
        if (!logger.isDebugEnabled() || !this.measurementsTaken()) {
            return;
        }
        if (this.ruleCounter.countForwardLinkBackwardLinkRule > 0) {
            logger.debug((Object)("Forward link from backward link rules: " + this.ruleCounter.countForwardLinkBackwardLinkRule + " (" + this.ruleTimer.timeForwardLinkBackwardLinkRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countDisjointnessAxiomContradictionRule > 0) {
            logger.debug((Object)("Disjointness axiom contradiction rules: " + this.ruleCounter.countDisjointnessAxiomContradictionRule + " (" + this.ruleTimer.timeDisjointnessAxiomContradictionRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countDisjointnessAxiomCompositionRule > 0) {
            logger.debug((Object)("Disjointness axiom composition rules: " + this.ruleCounter.countDisjointnessAxiomCompositionRule + " (" + this.ruleTimer.timeDisjointnessAxiomCompositionRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countOwlThingContextInitializationRule > 0) {
            logger.debug((Object)("owl:Thing context init rules: " + this.ruleCounter.countOwlThingContextInitializationRule + " (" + this.ruleTimer.timeOwlThingContextInitializationRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countContextRootInitializationRule > 0) {
            logger.debug((Object)("Context root init rules: " + this.ruleCounter.countContextRootInitializationRule + " (" + this.ruleTimer.timeContextRootInitializationRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countSubClassOfAxiomCompositionRule > 0) {
            logger.debug((Object)("Subclass expansions: " + this.ruleCounter.countSubClassOfAxiomCompositionRule + " (" + this.ruleTimer.timeSubClassOfAxiomCompositionRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countContradictionBottomBackwardLinkRule > 0) {
            logger.debug((Object)("Propagations of inconsistency: " + this.ruleCounter.countContradictionBottomBackwardLinkRule + " (" + this.ruleTimer.timeContradictionBottomBackwardLinkRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countPropagationBackwardLinkRule > 0) {
            logger.debug((Object)("Propagations via backward links: " + this.ruleCounter.countPropagationBackwardLinkRule + " (" + this.ruleTimer.timePropagationBackwardLinkRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countObjectSomeValuesFromCompositionRule + this.decompositionRuleCounter.countIndexedObjectSomeValuesFromDecompositionRule > 0) {
            logger.debug((Object)("ObjectSomeValuesFrom composition/decomposition rules: " + this.ruleCounter.countObjectSomeValuesFromCompositionRule + "/" + this.decompositionRuleCounter.countIndexedObjectSomeValuesFromDecompositionRule + " (" + this.ruleTimer.timeObjectSomeValuesFromCompositionRule / this.numOfMeasurements_ + "/" + this.decompositionRuleTimer.timeIndexedObjectSomeValuesFrom / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countObjectIntersectionOfCompositionRule + this.decompositionRuleCounter.countIndexedObjectIntersectionOfDecompositionRule > 0) {
            logger.debug((Object)("ObjectIntersectionOf composition/decomposition rules: " + this.ruleCounter.countObjectIntersectionOfCompositionRule + "/" + this.decompositionRuleCounter.countIndexedObjectIntersectionOfDecompositionRule + " (" + this.ruleTimer.timeObjectIntersectionOfCompositionRule / this.numOfMeasurements_ + "/" + this.decompositionRuleTimer.timeIndexedObjectIntersectionOf / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countObjectComplementOfCompositionRule + this.decompositionRuleCounter.countIndexedObjectComplementOfDecompositionRule > 0) {
            logger.debug((Object)("ObjectComplementOf composition/decomposition rules: " + this.ruleCounter.countObjectComplementOfCompositionRule + "/" + this.decompositionRuleCounter.countIndexedObjectComplementOfDecompositionRule + " (" + this.ruleTimer.timeObjectComplementOfCompositionRule / this.numOfMeasurements_ + "/" + this.decompositionRuleTimer.timeIndexedObjectComplementOf / this.numOfMeasurements_ + " ms)"));
        }
        if (this.ruleCounter.countObjectUnionOfCompositionRule > 0) {
            logger.debug((Object)("ObjectUnionOf composition rules: " + this.ruleCounter.countObjectUnionOfCompositionRule + " (" + this.ruleTimer.timeObjectUnionOfCompositionRule / this.numOfMeasurements_ + " ms)"));
        }
        if (this.decompositionRuleCounter.countIndexedClassDecompositionRule > 0) {
            logger.debug((Object)("Class decomposition rules: " + this.decompositionRuleCounter.countIndexedClassDecompositionRule + " (" + this.decompositionRuleTimer.timeIndexedClass / this.numOfMeasurements_ + " ms)"));
        }
        logger.debug((Object)("Total rule time: " + (this.ruleTimer.timeContradictionBottomBackwardLinkRule + this.ruleTimer.timeDisjointnessAxiomCompositionRule + this.ruleTimer.timeDisjointnessAxiomContradictionRule + this.ruleTimer.timeForwardLinkBackwardLinkRule + this.ruleTimer.timeObjectIntersectionOfCompositionRule + this.ruleTimer.timeObjectSomeValuesFromCompositionRule + this.ruleTimer.timeObjectComplementOfCompositionRule + this.ruleTimer.timeObjectUnionOfCompositionRule + this.ruleTimer.timeOwlThingContextInitializationRule + this.ruleTimer.timeContextRootInitializationRule + this.ruleTimer.timePropagationBackwardLinkRule + this.ruleTimer.timeSubClassOfAxiomCompositionRule + this.decompositionRuleTimer.timeIndexedClass + this.decompositionRuleTimer.timeIndexedDataHasValue + this.decompositionRuleTimer.timeIndexedObjectIntersectionOf + this.decompositionRuleTimer.timeIndexedObjectSomeValuesFrom + this.decompositionRuleTimer.timeIndexedObjectComplementOf) / this.numOfMeasurements_ + " ms"));
    }

    public long getTotalRuleAppCount() {
        return this.ruleCounter.getTotalRuleAppCount() + this.decompositionRuleCounter.getTotalRuleAppCount();
    }

    public double getTotalRuleTime() {
        double compTotal = this.numOfMeasurements_ == 0 ? 0.0 : 1.0 * (double)this.ruleTimer.getTotalRuleAppTime() / (double)this.numOfMeasurements_;
        double decompTotal = this.numOfMeasurements_ == 0 ? 0.0 : 1.0 * (double)this.decompositionRuleTimer.getTotalRuleAppTime() / (double)this.numOfMeasurements_;
        return compTotal + decompTotal;
    }
}

