/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Test;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.managers.ElkEntityRecycler;
import org.semanticweb.elk.owl.managers.ElkObjectRecycler;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.taxonomy.BasicTaxonomyValidator;
import org.semanticweb.elk.reasoner.taxonomy.InvalidTaxonomyException;
import org.semanticweb.elk.reasoner.taxonomy.MockInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.MockTaxonomyLoader;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyAcyclicityAndReductionValidator;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyLinkConsistencyVisitor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeDisjointnessVisitor;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;

public class TaxonomyValidatorTest {
    @Test
    public void testAllGood() throws Exception {
        Taxonomy<ElkClass> taxonomy = this.load("io/taxonomy.owl");
        BasicTaxonomyValidator<ElkClass> validator = new BasicTaxonomyValidator<ElkClass>().add(new TaxonomyNodeDisjointnessVisitor<ElkClass>(taxonomy)).add(new TaxonomyLinkConsistencyVisitor());
        validator.validate(taxonomy);
        new TaxonomyAcyclicityAndReductionValidator<ElkClass>().validate(taxonomy);
    }

    @Test(expected=InvalidTaxonomyException.class)
    public void testNodesNonDisjoint() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getTypeNode((ElkObject)A).members.add(B);
        taxonomy.getTypeNode((ElkObject)C).members.add(B);
        BasicTaxonomyValidator validator = new BasicTaxonomyValidator().add(new TaxonomyNodeDisjointnessVisitor(taxonomy));
        validator.validate(taxonomy);
    }

    @Test(expected=InvalidTaxonomyException.class)
    public void testNodeLinksInconsistent() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getCreateTypeNode(Arrays.asList(D));
        taxonomy.getTypeNode((ElkObject)C).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)B));
        taxonomy.parentMap.get(taxonomy.getTypeNode((ElkObject)C)).add(taxonomy.getTypeNode((ElkObject)B));
        BasicTaxonomyValidator validator = new BasicTaxonomyValidator().add(new TaxonomyLinkConsistencyVisitor());
        validator.validate(taxonomy);
    }

    @Test
    public void testAcyclic() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getCreateTypeNode(Arrays.asList(D));
        taxonomy.getTypeNode((ElkObject)B).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)C).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)B));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)C));
        new TaxonomyAcyclicityAndReductionValidator().validate(taxonomy);
    }

    @Test(expected=InvalidTaxonomyException.class)
    public void testCyclic() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getCreateTypeNode(Arrays.asList(D));
        taxonomy.getTypeNode((ElkObject)B).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)C).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)B));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)C));
        taxonomy.getTypeNode((ElkObject)A).addDirectParent(taxonomy.getTypeNode((ElkObject)D));
        new TaxonomyAcyclicityAndReductionValidator().validate(taxonomy);
    }

    @Test(expected=InvalidTaxonomyException.class)
    public void testSelfLoop() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getCreateTypeNode(Arrays.asList(D));
        taxonomy.getTypeNode((ElkObject)B).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)C).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)B));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)C));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)D));
        new TaxonomyAcyclicityAndReductionValidator().validate(taxonomy);
    }

    @Test(expected=InvalidTaxonomyException.class)
    public void testNonReduced() throws Exception {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.createEmptyTaxonomy();
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Arrays.asList(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B));
        taxonomy.getCreateTypeNode(Arrays.asList(C));
        taxonomy.getCreateTypeNode(Arrays.asList(D));
        taxonomy.getTypeNode((ElkObject)B).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)C).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)B));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)C));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        new TaxonomyAcyclicityAndReductionValidator().validate(taxonomy);
    }

    private MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> createEmptyTaxonomy() {
        return new MockInstanceTaxonomy(PredefinedElkClass.OWL_THING, PredefinedElkClass.OWL_NOTHING, Comparators.ELK_CLASS_COMPARATOR, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Taxonomy<ElkClass> load(String resource) throws IOException, Owl2ParseException, ElkInconsistentOntologyException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy;
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            ElkObjectFactoryImpl objectFactory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
            instanceTaxonomy = MockTaxonomyLoader.load((ElkObjectFactory)objectFactory, new Owl2FunctionalStyleParserFactory((ElkObjectFactory)objectFactory).getParser(stream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return instanceTaxonomy;
    }
}

