/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.InvalidTaxonomyException;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeVisitor;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class TaxonomyNodeIndexConsistencyVisitor<T extends ElkObject>
implements TaxonomyNodeVisitor<T> {
    private final Taxonomy<T> taxonomy_;

    public TaxonomyNodeIndexConsistencyVisitor(Taxonomy<T> t) {
        this.taxonomy_ = t;
    }

    public void visit(TaxonomyNode<T> node, List<TaxonomyNode<T>> pathFromStart) {
        if (!node.getMembers().contains(node.getCanonicalMember())) {
            throw new InvalidTaxonomyException("Canonical member is not a member? " + node.getCanonicalMember() + ", members: " + node.getMembers());
        }
        for (ElkObject obj : node.getMembers()) {
            TaxonomyNode n = this.taxonomy_.getNode(obj);
            if (n == node) continue;
            throw new InvalidTaxonomyException("Invalid taxonomy node index at object " + obj);
        }
    }
}

