/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.Owl2StreamLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.managers.ElkEntityRecycler;
import org.semanticweb.elk.owl.managers.ElkObjectRecycler;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.stages.FailingOnInterruptStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.MockTaxonomyLoader;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;

public class TaxonomyIOTest {
    private final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
    private final Owl2ParserFactory parserFactory = new Owl2FunctionalStyleParserFactory(this.objectFactory);

    @Test
    public void classTaxonomyRoundtrip() throws IOException, Owl2ParseException, ElkInconsistentOntologyException, ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> original = this.loadAndClassify("io/taxonomy.owl");
        StringWriter writer = new StringWriter();
        TaxonomyPrinter.dumpClassTaxomomy(original, (Writer)writer, (boolean)false);
        StringReader reader = new StringReader(writer.getBuffer().toString());
        Owl2Parser parser = this.parserFactory.getParser((Reader)reader);
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> loaded = MockTaxonomyLoader.load(this.objectFactory, parser);
        Assert.assertEquals((long)TaxonomyHasher.hash(original), (long)TaxonomyHasher.hash(loaded));
    }

    @Test
    public void instanceTaxonomyRoundtrip() throws IOException, Owl2ParseException, ElkInconsistentOntologyException, ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> original = this.loadAndClassify("io/instance_taxonomy.owl");
        StringWriter writer = new StringWriter();
        OutputStreamWriter outWriter = new OutputStreamWriter(System.out);
        TaxonomyPrinter.dumpInstanceTaxomomy(original, (Writer)outWriter, (boolean)false);
        ((Writer)outWriter).flush();
        TaxonomyPrinter.dumpInstanceTaxomomy(original, (Writer)writer, (boolean)false);
        StringReader reader = new StringReader(writer.getBuffer().toString());
        Owl2Parser parser = this.parserFactory.getParser((Reader)reader);
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> loaded = MockTaxonomyLoader.load(this.objectFactory, parser);
        System.out.println("=================================");
        outWriter = new OutputStreamWriter(System.out);
        TaxonomyPrinter.dumpInstanceTaxomomy(loaded, (Writer)outWriter, (boolean)false);
        ((Writer)outWriter).flush();
        Assert.assertEquals((long)InstanceTaxonomyHasher.hash(original), (long)InstanceTaxonomyHasher.hash(loaded));
    }

    @Test
    public void taxonomyEquivalence() throws IOException, Owl2ParseException, ElkInconsistentOntologyException {
        Taxonomy<ElkClass> taxonomy1 = this.load("io/taxonomy_eq_1.owl");
        Taxonomy<ElkClass> taxonomy2 = this.load("io/taxonomy_eq_2.owl");
        Assert.assertEquals((Object)TaxonomyPrinter.getHashString(taxonomy1), (Object)TaxonomyPrinter.getHashString(taxonomy2));
    }

    @Test
    public void loadInconsistent() throws IOException, Owl2ParseException, ElkInconsistentOntologyException {
        Taxonomy<ElkClass> taxonomy = this.load("io/inconsistent.owl");
        Assert.assertEquals((long)1L, (long)taxonomy.getNodes().size());
        Assert.assertSame((Object)taxonomy.getTopNode(), (Object)taxonomy.getBottomNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceTaxonomy<ElkClass, ElkNamedIndividual> loadAndClassify(String resource) throws IOException, Owl2ParseException, ElkInconsistentOntologyException, ElkException {
        InstanceTaxonomy instanceTaxonomy;
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            Owl2StreamLoader streamLoader = new Owl2StreamLoader((Owl2ParserFactory)new Owl2FunctionalStyleParserFactory(), stream);
            Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)streamLoader, (ReasonerStageExecutor)new FailingOnInterruptStageExecutor(), 1);
            instanceTaxonomy = reasoner.getInstanceTaxonomy();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return instanceTaxonomy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Taxonomy<ElkClass> load(String resource) throws IOException, Owl2ParseException, ElkInconsistentOntologyException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy;
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            instanceTaxonomy = MockTaxonomyLoader.load(this.objectFactory, this.parserFactory.getParser(stream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return instanceTaxonomy;
    }
}

