/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.DepthFirstSearch;
import org.semanticweb.elk.reasoner.taxonomy.InvalidTaxonomyException;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeVisitor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyValidator;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class TaxonomyAcyclicityAndReductionValidator<T extends ElkObject>
implements TaxonomyValidator<T> {
    @Override
    public void validate(Taxonomy<T> taxonomy) {
        for (TaxonomyNode node : taxonomy.getNodes()) {
            if (node == taxonomy.getTopNode()) continue;
            this.check(node);
        }
    }

    private void check(final TaxonomyNode<T> current) {
        final Set<TaxonomyNode<T>> directSuccessors = DepthFirstSearch.getSuccessors(current, DepthFirstSearch.Direction.DOWN);
        if (directSuccessors.contains(current)) {
            throw new InvalidTaxonomyException("Self loop at " + current);
        }
        TaxonomyNodeVisitor checker = new TaxonomyNodeVisitor<T>(){

            public void visit(TaxonomyNode<T> node, List<TaxonomyNode<T>> pathFromStart) {
                if (pathFromStart.size() > 1) {
                    if (node == current) {
                        throw new InvalidTaxonomyException("Cycle detected at " + current);
                    }
                    if (directSuccessors.contains(node)) {
                        throw new InvalidTaxonomyException("Taxonomy not transitively reduced at " + current);
                    }
                }
            }
        };
        new DepthFirstSearch<T>().run(current, DepthFirstSearch.Direction.DOWN, checker);
    }
}

