/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.elk.owl.AbstractElkAxiomVisitor;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.owl.visitors.AbstractElkEntityVisitor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.reasoner.taxonomy.MockInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;

public class MockTaxonomyLoader {
    public static InstanceTaxonomy<ElkClass, ElkNamedIndividual> load(ElkObjectFactory factory, Owl2Parser parser) throws Owl2ParseException {
        MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = new MockInstanceTaxonomy<ElkClass, ElkNamedIndividual>(factory.getClass(PredefinedElkClass.OWL_THING.getIri()), factory.getClass(PredefinedElkClass.OWL_NOTHING.getIri()), Comparators.ELK_CLASS_COMPARATOR, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
        TaxonomyInserter listener = new TaxonomyInserter(taxonomy);
        parser.accept((Owl2ParserAxiomProcessor)listener);
        listener.createNodes = true;
        MockTaxonomyLoader.process(listener, listener.classDeclarations);
        MockTaxonomyLoader.process(listener, listener.subClassOfAxioms);
        MockTaxonomyLoader.process(listener, listener.individualDeclarations);
        return taxonomy;
    }

    private static void process(TaxonomyInserter inserter, List<ElkAxiom> axioms) {
        for (ElkAxiom decl : axioms) {
            decl.accept((ElkAxiomVisitor)inserter);
        }
    }

    static class TaxonomyInserter
    extends AbstractElkAxiomVisitor<Void>
    implements Owl2ParserAxiomProcessor {
        boolean createNodes = false;
        final MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy;
        final List<ElkAxiom> subClassOfAxioms = new ArrayList<ElkAxiom>();
        final List<ElkAxiom> classDeclarations = new ArrayList<ElkAxiom>();
        final List<ElkAxiom> individualDeclarations = new ArrayList<ElkAxiom>();

        TaxonomyInserter(MockInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) {
            this.taxonomy = taxonomy;
        }

        public Void visit(ElkEquivalentClassesAxiom elkEquivalentClassesAxiom) {
            HashSet<ElkClass> classes = new HashSet<ElkClass>();
            for (ElkClassExpression ce : elkEquivalentClassesAxiom.getClassExpressions()) {
                if (!(ce instanceof ElkClass)) continue;
                classes.add((ElkClass)ce);
            }
            this.taxonomy.getCreateTypeNode(classes);
            return null;
        }

        public Void visit(ElkSubClassOfAxiom elkSubClassOfAxiom) {
            ElkClassExpression subCE = elkSubClassOfAxiom.getSubClassExpression();
            ElkClassExpression superCE = elkSubClassOfAxiom.getSuperClassExpression();
            if (subCE instanceof ElkClass && superCE instanceof ElkClass) {
                ElkClass subClass = (ElkClass)subCE;
                ElkClass superClass = (ElkClass)superCE;
                MockInstanceTaxonomy.MutableTypeNode<ElkClass, ElkNamedIndividual> subNode = this.taxonomy.getTypeNode((ElkObject)subClass);
                MockInstanceTaxonomy.MutableTypeNode<ElkClass, ElkNamedIndividual> superNode = this.taxonomy.getTypeNode((ElkObject)superClass);
                if (!(subNode != null && superNode != null || this.createNodes)) {
                    this.subClassOfAxioms.add((ElkAxiom)elkSubClassOfAxiom);
                } else {
                    subNode = this.taxonomy.getCreateTypeNode(Collections.singleton(subClass));
                    superNode = this.taxonomy.getCreateTypeNode(Collections.singleton(superClass));
                    subNode.addDirectParent(superNode);
                }
            }
            return null;
        }

        public Void visit(final ElkDeclarationAxiom elkDeclarationAxiom) {
            ElkEntity entity = elkDeclarationAxiom.getEntity();
            entity.accept((ElkEntityVisitor)new AbstractElkEntityVisitor<Object>(){

                public Object visit(ElkClass elkClass) {
                    if (TaxonomyInserter.this.createNodes) {
                        TaxonomyInserter.this.taxonomy.getCreateTypeNode(Collections.singleton(elkClass));
                    } else {
                        TaxonomyInserter.this.classDeclarations.add((ElkAxiom)elkDeclarationAxiom);
                    }
                    return null;
                }

                public Object visit(ElkNamedIndividual elkNamedIndividual) {
                    if (TaxonomyInserter.this.createNodes) {
                        TaxonomyInserter.this.taxonomy.getCreateInstanceNode(Collections.singleton(elkNamedIndividual), Collections.emptyList());
                    } else {
                        TaxonomyInserter.this.individualDeclarations.add((ElkAxiom)elkDeclarationAxiom);
                    }
                    return null;
                }
            });
            return null;
        }

        public Void visit(ElkClassAssertionAxiom elkClassAssertionAxiom) {
            if (elkClassAssertionAxiom.getClassExpression() instanceof ElkClass && elkClassAssertionAxiom.getIndividual() instanceof ElkNamedIndividual) {
                ElkClass type = (ElkClass)elkClassAssertionAxiom.getClassExpression();
                ElkNamedIndividual individual = (ElkNamedIndividual)elkClassAssertionAxiom.getIndividual();
                MockInstanceTaxonomy.MutableTypeNode<ElkClass, ElkNamedIndividual> typeNode = this.taxonomy.getTypeNode((ElkObject)type);
                if (typeNode == null && !this.createNodes) {
                    this.subClassOfAxioms.add((ElkAxiom)elkClassAssertionAxiom);
                } else {
                    InstanceNode indNode = this.taxonomy.getInstanceNode((ElkObject)individual);
                    typeNode = this.taxonomy.getCreateTypeNode(Collections.singleton(type));
                    if (indNode == null) {
                        indNode = this.taxonomy.getCreateInstanceNode(Collections.singleton(individual), Collections.singleton(typeNode));
                    } else {
                        typeNode.addDirectInstance((InstanceNode<ElkClass, ElkNamedIndividual>)indNode);
                    }
                }
            }
            return null;
        }

        public void visit(ElkAxiom elkAxiom) {
            elkAxiom.accept((ElkAxiomVisitor)this);
        }

        public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
        }

        public void finish() throws Owl2ParseException {
        }
    }
}

