/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.managers.ElkEntityRecycler;
import org.semanticweb.elk.owl.managers.ElkObjectRecycler;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.MockInstanceTaxonomy;

public class MockInstanceTaxonomyTest {
    @Test
    public void testTopBotEquivalence() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
        MockInstanceTaxonomy taxonomy = new MockInstanceTaxonomy(PredefinedElkClass.OWL_THING, PredefinedElkClass.OWL_NOTHING, Comparators.ELK_CLASS_COMPARATOR, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        taxonomy.getCreateTypeNode(Collections.singleton(A));
        taxonomy.getTopNode().addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        Assert.assertSame((Object)taxonomy.getTopNode(), (Object)taxonomy.getTypeNode((ElkObject)A));
        Assert.assertEquals((long)2L, (long)taxonomy.getTopNode().getMembers().size());
        Assert.assertEquals((long)2L, (long)taxonomy.getTypeNodes().size());
        Assert.assertEquals((long)2L, (long)taxonomy.getNodes().size());
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        taxonomy.getCreateTypeNode(Collections.singleton(B));
        taxonomy.getTypeNode((ElkObject)B).addDirectParent(taxonomy.getBottomNode());
        Assert.assertSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getTypeNode((ElkObject)B));
        Assert.assertEquals((long)2L, (long)taxonomy.getBottomNode().getMembers().size());
        Assert.assertEquals((long)2L, (long)taxonomy.getTypeNodes().size());
        Assert.assertEquals((long)2L, (long)taxonomy.getNodes().size());
    }

    @Test
    public void testForDuplicates() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
        MockInstanceTaxonomy<PredefinedElkClass, ElkNamedIndividual> taxonomy = new MockInstanceTaxonomy<PredefinedElkClass, ElkNamedIndividual>(PredefinedElkClass.OWL_THING, PredefinedElkClass.OWL_NOTHING, Comparators.ELK_CLASS_COMPARATOR, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
        ElkClass A1 = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass A2 = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkNamedIndividual a1 = factory.getNamedIndividual((ElkIri)new ElkFullIri("#a"));
        ElkNamedIndividual a2 = factory.getNamedIndividual((ElkIri)new ElkFullIri("#a"));
        taxonomy.getCreateTypeNode(Collections.singleton(A1));
        taxonomy.getCreateTypeNode(Collections.singleton(A2));
        Assert.assertSame((Object)taxonomy.getTypeNode((ElkObject)A1), (Object)taxonomy.getTypeNode((ElkObject)A2));
        taxonomy.getCreateInstanceNode(Collections.singleton(a1), Collections.singleton(taxonomy.getTypeNode((ElkObject)A1)));
        taxonomy.getCreateInstanceNode(Collections.singleton(a2), Collections.singleton(taxonomy.getTypeNode((ElkObject)A2)));
        Assert.assertSame((Object)taxonomy.getInstanceNode((ElkObject)a1), (Object)taxonomy.getInstanceNode((ElkObject)a2));
    }

    @Test
    public void testMockTaxonomy() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl((ElkObjectRecycler)new ElkEntityRecycler());
        MockInstanceTaxonomy<PredefinedElkClass, ElkNamedIndividual> taxonomy = new MockInstanceTaxonomy<PredefinedElkClass, ElkNamedIndividual>(PredefinedElkClass.OWL_THING, PredefinedElkClass.OWL_NOTHING, Comparators.ELK_CLASS_COMPARATOR, Comparators.ELK_NAMED_INDIVIDUAL_COMPARATOR);
        Assert.assertSame((Object)PredefinedElkClass.OWL_THING, (Object)taxonomy.getTopNode().getCanonicalMember());
        Assert.assertSame((Object)PredefinedElkClass.OWL_NOTHING, taxonomy.getBottomNode().getCanonicalMember());
        Assert.assertSame((Object)taxonomy.getTopNode(), taxonomy.getBottomNode().getDirectSuperNodes().iterator().next());
        Assert.assertSame((Object)taxonomy.getBottomNode(), taxonomy.getTopNode().getAllSubNodes().iterator().next());
        ElkClass A = factory.getClass((ElkIri)new ElkFullIri("#A"));
        ElkClass B = factory.getClass((ElkIri)new ElkFullIri("#B"));
        ElkClass C = factory.getClass((ElkIri)new ElkFullIri("#C"));
        taxonomy.getCreateTypeNode(Collections.singleton(A));
        taxonomy.getCreateTypeNode(Arrays.asList(B, C));
        Assert.assertEquals((long)4L, (long)taxonomy.getTypeNodes().size());
        Assert.assertSame((Object)taxonomy.getTypeNode((ElkObject)B), (Object)taxonomy.getTypeNode((ElkObject)C));
        Assert.assertEquals(Collections.singleton(taxonomy.getTopNode()), taxonomy.getTypeNode((ElkObject)A).getDirectSuperNodes());
        Assert.assertEquals(Collections.singleton(taxonomy.getBottomNode()), taxonomy.getTypeNode((ElkObject)B).getDirectSubNodes());
        ElkClass D = factory.getClass((ElkIri)new ElkFullIri("#D"));
        taxonomy.getCreateTypeNode(Collections.singleton(D));
        taxonomy.getTypeNode((ElkObject)D).addDirectParent(taxonomy.getTypeNode((ElkObject)A));
        Assert.assertEquals(Collections.singleton(taxonomy.getTypeNode((ElkObject)A)), taxonomy.getTypeNode((ElkObject)D).getDirectSuperNodes());
        Assert.assertEquals(Collections.singleton(taxonomy.getTypeNode((ElkObject)D)), taxonomy.getTypeNode((ElkObject)A).getDirectSubNodes());
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockTypeNode>(Arrays.asList(taxonomy.getTypeNode((ElkObject)A), taxonomy.getTypeNode((ElkObject)B))), (Object)taxonomy.getTopNode().getDirectSubNodes());
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockTypeNode>(Arrays.asList(taxonomy.getTypeNode((ElkObject)D), taxonomy.getTypeNode((ElkObject)B))), taxonomy.getBottomNode().getDirectSuperNodes());
        ElkNamedIndividual a = factory.getNamedIndividual((ElkIri)new ElkFullIri("#a"));
        ElkNamedIndividual b = factory.getNamedIndividual((ElkIri)new ElkFullIri("#b"));
        ElkNamedIndividual c = factory.getNamedIndividual((ElkIri)new ElkFullIri("#c"));
        ElkNamedIndividual d = factory.getNamedIndividual((ElkIri)new ElkFullIri("#d"));
        taxonomy.getCreateInstanceNode(Arrays.asList(a, b), Collections.emptySet());
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockInstanceNode>(Arrays.asList(taxonomy.getInstanceNode((ElkObject)a))), (Object)taxonomy.getTopNode().getDirectInstanceNodes());
        Assert.assertSame((Object)taxonomy.getTopNode(), taxonomy.getInstanceNode((ElkObject)a).getDirectTypeNodes().iterator().next());
        taxonomy.getCreateInstanceNode(Arrays.asList(c), Arrays.asList(taxonomy.getTypeNode((ElkObject)A)));
        taxonomy.getCreateInstanceNode(Arrays.asList(d), Arrays.asList(taxonomy.getTypeNode((ElkObject)D)));
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockInstanceNode>(Arrays.asList(taxonomy.getInstanceNode((ElkObject)c))), taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes());
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockInstanceNode>(Arrays.asList(taxonomy.getInstanceNode((ElkObject)c), taxonomy.getInstanceNode((ElkObject)d))), taxonomy.getTypeNode((ElkObject)A).getAllInstanceNodes());
        Assert.assertEquals(new HashSet<MockInstanceTaxonomy.MockTypeNode>(Arrays.asList(taxonomy.getTypeNode((ElkObject)A), taxonomy.getTypeNode((ElkObject)D))), taxonomy.getInstanceNode((ElkObject)d).getAllTypeNodes());
    }
}

