/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.taxonomy.DepthFirstSearch;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Operations;

public class MockInstanceTaxonomy<T extends ElkObject, I extends ElkObject>
implements InstanceTaxonomy<T, I> {
    protected ExtremeNode<T, I> top;
    protected final MockBottomNode bottom;
    protected final Map<TypeNode<T, I>, Set<TypeNode<T, I>>> parentMap = new HashMap<TypeNode<T, I>, Set<TypeNode<T, I>>>();
    protected final Map<TypeNode<T, I>, Set<TypeNode<T, I>>> childrenMap = new HashMap<TypeNode<T, I>, Set<TypeNode<T, I>>>();
    protected final Map<T, TypeNode<T, I>> typeIndex = new HashMap<T, TypeNode<T, I>>();
    protected final Map<I, MockInstanceNode> instanceIndex = new HashMap<I, MockInstanceNode>();
    protected final Map<MockInstanceNode, Set<TypeNode<T, I>>> instanceTypeMap = new HashMap<MockInstanceNode, Set<TypeNode<T, I>>>();
    private int nodesWithoutParent = 0;
    private int nodesWithoutChildren = 0;
    private int instancesWithoutType = 0;
    protected final Comparator<T> typeComparator;
    protected final Comparator<I> instanceComparator;

    MockInstanceTaxonomy(T top, T bottom, Comparator<T> tCmp, Comparator<I> iCmp) {
        this.typeComparator = tCmp;
        this.instanceComparator = iCmp;
        this.top = new MockTopNode(this, top);
        this.bottom = new MockBottomNode(this, bottom);
        this.initTypeNode(this.top);
        this.initTypeNode(this.bottom);
    }

    private void initTypeNode(TypeNode<T, I> typeNode) {
        for (ElkObject member : typeNode.getMembers()) {
            this.typeIndex.put(member, typeNode);
        }
        this.parentMap.put(typeNode, new HashSet());
        this.childrenMap.put(typeNode, new HashSet());
    }

    public TaxonomyNode<T> getNode(T elkObject) {
        return this.getTypeNode((ElkObject)elkObject);
    }

    public Set<? extends TaxonomyNode<T>> getNodes() {
        return this.getTypeNodes();
    }

    public ExtremeNode<T, I> getTopNode() {
        return this.top;
    }

    public MockBottomNode getBottomNode() {
        return this.bottom;
    }

    public MockTypeNode getTypeNode(T elkObject) {
        return (MockTypeNode)this.typeIndex.get(elkObject);
    }

    public Set<? extends TypeNode<T, I>> getTypeNodes() {
        return this.parentMap.keySet();
    }

    public MockInstanceNode getInstanceNode(I elkObject) {
        return this.instanceIndex.get(elkObject);
    }

    public Set<? extends InstanceNode<T, I>> getInstanceNodes() {
        return this.instanceTypeMap.keySet();
    }

    protected void makeInconsistent() {
        this.parentMap.clear();
        this.childrenMap.clear();
        this.instanceIndex.clear();
        this.typeIndex.clear();
        this.instanceTypeMap.clear();
        this.bottom.addMembers(this.top.getMembers());
        this.top = this.bottom;
        this.initTypeNode(this.bottom);
    }

    public boolean isConsistent() {
        return this.top != this.bottom;
    }

    public MutableTypeNode<T, I> getCreateTypeNode(Collection<T> types) {
        if (types.contains(this.top.getCanonicalMember()) && types.contains(this.bottom.getCanonicalMember())) {
            this.makeInconsistent();
            this.bottom.addMembers(types);
            return this.bottom;
        }
        MutableTypeNode node = null;
        MutableTypeNode extreme = null;
        for (ElkObject type : types) {
            if (type.equals(this.top.getCanonicalMember()) || type.equals(this.bottom.getCanonicalMember())) {
                extreme = (ExtremeNode)this.getTypeNode(type);
                continue;
            }
            TypeNode typeNode = this.getTypeNode(type);
            assert (node == null || node == typeNode);
            node = typeNode;
        }
        if (node == null) {
            if (extreme != null) {
                extreme.addMembers(types);
                node = extreme;
            } else {
                node = new MockTypeNode(types);
                this.initTypeNode(node);
                ++this.nodesWithoutParent;
                ++this.nodesWithoutChildren;
            }
        } else if (extreme != null) {
            extreme.merge(node);
        } else {
            node.addMembers(types);
        }
        return node;
    }

    public MockInstanceNode getCreateInstanceNode(Collection<I> instances, Collection<TypeNode<T, I>> types) {
        MockInstanceNode node = this.instanceIndex.get(instances.iterator().next());
        if (node == null) {
            node = new MockInstanceNode(instances, types);
            for (ElkObject instance : instances) {
                this.instanceIndex.put(instance, node);
            }
        }
        return node;
    }

    protected void remove(TypeNode<T, I> node) {
        for (TypeNode subNode : node.getDirectSubNodes()) {
            this.parentMap.get(subNode).remove(node);
        }
        for (TypeNode supNode : node.getDirectSuperNodes()) {
            this.childrenMap.get(supNode).remove(node);
        }
        for (InstanceNode instanceNode : node.getDirectInstanceNodes()) {
            this.instanceTypeMap.get(instanceNode).remove(node);
        }
        if (this.parentMap.get(node).isEmpty()) {
            --this.nodesWithoutParent;
        }
        if (this.childrenMap.get(node).isEmpty()) {
            --this.nodesWithoutChildren;
        }
        this.parentMap.remove(node);
        this.childrenMap.remove(node);
        this.instanceTypeMap.remove(node);
    }

    protected class MockInstanceNode
    extends MockNode<I>
    implements InstanceNode<T, I> {
        MockInstanceNode(Collection<I> members, Collection<TypeNode<T, I>> types) {
            super(members, MockInstanceTaxonomy.this.instanceComparator);
            MockInstanceTaxonomy.this.instancesWithoutType++;
            MockInstanceTaxonomy.this.instanceTypeMap.put(this, new ArrayHashSet());
            for (TypeNode type : types) {
                assert (type != null);
                ((MockTypeNode)type).addDirectInstance(this);
            }
        }

        public Set<? extends TypeNode<T, I>> getDirectTypeNodes() {
            Set typeNodes = MockInstanceTaxonomy.this.instanceTypeMap.get(this);
            return typeNodes.isEmpty() ? Collections.singleton(MockInstanceTaxonomy.this.getTopNode()) : typeNodes;
        }

        public Set<? extends TypeNode<T, I>> getAllTypeNodes() {
            HashSet allTypes = new HashSet();
            for (TypeNode aType : this.getDirectTypeNodes()) {
                allTypes.addAll(aType.getAllSuperNodes());
                allTypes.add(aType);
            }
            if (allTypes.size() > 1) {
                allTypes.remove(MockInstanceTaxonomy.this.getTopNode());
            }
            return allTypes;
        }

        @Override
        protected void addMembers(Collection<I> members) {
            for (ElkObject member : members) {
                this.members.add(member);
                MockInstanceTaxonomy.this.instanceIndex.put(member, this);
            }
        }
    }

    static class MockBottomNode
    extends MockTypeNode
    implements ExtremeNode<T, I> {
        final /* synthetic */ MockInstanceTaxonomy this$0;

        MockBottomNode(T bot) {
            this.this$0 = this$0;
            super(Collections.singleton(bot));
        }

        @Override
        public Set<? extends InstanceNode<T, I>> getDirectInstanceNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<? extends InstanceNode<T, I>> getAllInstanceNodes() {
            return Collections.emptySet();
        }

        @Override
        public void merge(TypeNode<T, I> node) {
            this.addMembers(node.getMembers());
            if (!node.getDirectInstanceNodes().isEmpty()) {
                this.this$0.makeInconsistent();
            } else {
                this.this$0.remove(node);
            }
        }

        @Override
        public Set<TypeNode<T, I>> getDirectSuperNodes() {
            final boolean empty = this.this$0.childrenMap.size() == 2;
            return Operations.filter(this.this$0.childrenMap.keySet(), (Operations.Condition)new Operations.Condition<TaxonomyNode<T>>(){

                public boolean holds(TaxonomyNode<T> node) {
                    return node != MockBottomNode.this.this$0.getBottomNode() && MockBottomNode.this.this$0.childrenMap.get(node).isEmpty() && (node != MockBottomNode.this.this$0.getTopNode() || empty);
                }
            }, (int)(empty ? 1 : this.this$0.nodesWithoutChildren));
        }

        @Override
        public Set<TypeNode<T, I>> getAllSuperNodes() {
            return Operations.filter(this.this$0.childrenMap.keySet(), (Operations.Condition)new Operations.Condition<TaxonomyNode<T>>(){

                public boolean holds(TaxonomyNode<T> node) {
                    return node != MockBottomNode.this.this$0.getBottomNode();
                }
            }, (int)(this.this$0.childrenMap.size() - 1));
        }

        @Override
        public Set<TypeNode<T, I>> getDirectSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TypeNode<T, I>> getAllSubNodes() {
            return Collections.emptySet();
        }

        @Override
        public void addDirectInstance(InstanceNode<T, I> instance) {
            this.this$0.makeInconsistent();
        }
    }

    static class MockTopNode
    extends MockTypeNode
    implements ExtremeNode<T, I> {
        final /* synthetic */ MockInstanceTaxonomy this$0;

        MockTopNode(T top) {
            this.this$0 = this$0;
            super(Collections.singleton(top));
        }

        @Override
        public void merge(TypeNode<T, I> node) {
            this.addMembers(node.getMembers());
            this.this$0.remove(node);
        }

        @Override
        public void addDirectParent(TypeNode<T, I> node) {
            if (node == this.this$0.getBottomNode()) {
                this.this$0.makeInconsistent();
            } else {
                this.merge(node);
            }
        }

        @Override
        public Set<? extends InstanceNode<T, I>> getDirectInstanceNodes() {
            return Operations.filter(this.this$0.instanceTypeMap.keySet(), (Operations.Condition)new Operations.Condition<InstanceNode<T, I>>(){

                public boolean holds(InstanceNode<T, I> node) {
                    return MockTopNode.this.this$0.instanceTypeMap.get(node).isEmpty();
                }
            }, (int)this.this$0.instancesWithoutType);
        }

        @Override
        public Set<? extends InstanceNode<T, I>> getAllInstanceNodes() {
            return this.this$0.instanceTypeMap.keySet();
        }

        @Override
        public Set<TypeNode<T, I>> getDirectSuperNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TypeNode<T, I>> getAllSuperNodes() {
            return Collections.emptySet();
        }

        @Override
        public Set<TypeNode<T, I>> getDirectSubNodes() {
            final boolean empty = this.this$0.childrenMap.size() == 2;
            return Operations.filter(this.this$0.parentMap.keySet(), (Operations.Condition)new Operations.Condition<TaxonomyNode<T>>(){

                public boolean holds(TaxonomyNode<T> node) {
                    return node != MockTopNode.this.this$0.getTopNode() && MockTopNode.this.this$0.parentMap.get(node).isEmpty() && (node != MockTopNode.this.this$0.getBottomNode() || empty);
                }
            }, (int)(empty ? 1 : this.this$0.nodesWithoutParent));
        }

        @Override
        public Set<TypeNode<T, I>> getAllSubNodes() {
            return Operations.filter(this.this$0.parentMap.keySet(), (Operations.Condition)new Operations.Condition<TaxonomyNode<T>>(){

                public boolean holds(TaxonomyNode<T> node) {
                    return node != MockTopNode.this.this$0.getTopNode();
                }
            }, (int)(this.this$0.parentMap.keySet().size() - 1));
        }
    }

    static interface ExtremeNode<T extends ElkObject, I extends ElkObject>
    extends MutableTypeNode<T, I> {
        public void merge(TypeNode<T, I> var1);
    }

    protected class MockTypeNode
    extends MockNode<T>
    implements MutableTypeNode<T, I> {
        final Set<InstanceNode<T, I>> instances;

        MockTypeNode(Collection<T> members) {
            super(members, MockInstanceTaxonomy.this.typeComparator);
            this.instances = new ArrayHashSet();
        }

        public Set<? extends InstanceNode<T, I>> getDirectInstanceNodes() {
            return this.instances;
        }

        public Set<? extends InstanceNode<T, I>> getAllInstanceNodes() {
            Set ancestors = this.getAllSubNodes();
            ArrayHashSet result = new ArrayHashSet();
            result.addAll(this.instances);
            for (TypeNode ancestor : ancestors) {
                result.addAll(ancestor.getDirectInstanceNodes());
            }
            return result;
        }

        public Set<TypeNode<T, I>> getDirectSuperNodes() {
            Set sup = MockInstanceTaxonomy.this.parentMap.get(this);
            return sup.isEmpty() ? Collections.singleton(MockInstanceTaxonomy.this.getTopNode()) : Collections.unmodifiableSet(sup);
        }

        public Set<TypeNode<T, I>> getAllSuperNodes() {
            HashSet sups = new HashSet();
            this.computeSuccessors(this, sups, DepthFirstSearch.Direction.UP);
            if (sups.size() > 2) {
                sups.remove(MockInstanceTaxonomy.this.getTopNode());
                sups.remove(MockInstanceTaxonomy.this.getBottomNode());
            }
            return sups;
        }

        public Set<TypeNode<T, I>> getDirectSubNodes() {
            Set sub = MockInstanceTaxonomy.this.childrenMap.get(this);
            return sub.isEmpty() ? Collections.singleton(MockInstanceTaxonomy.this.getBottomNode()) : Collections.unmodifiableSet(sub);
        }

        public Set<TypeNode<T, I>> getAllSubNodes() {
            HashSet subs = new HashSet();
            this.computeSuccessors(this, subs, DepthFirstSearch.Direction.DOWN);
            if (subs.size() > 2) {
                subs.remove(MockInstanceTaxonomy.this.getTopNode());
                subs.remove(MockInstanceTaxonomy.this.getBottomNode());
            }
            return subs;
        }

        @Override
        public void addDirectParent(TypeNode<T, I> parent) {
            if (this != MockInstanceTaxonomy.this.getBottomNode() && parent != MockInstanceTaxonomy.this.getTopNode()) {
                if (parent == MockInstanceTaxonomy.this.getBottomNode()) {
                    MockInstanceTaxonomy.this.getBottomNode().merge(this);
                } else {
                    if (MockInstanceTaxonomy.this.childrenMap.get(parent).isEmpty()) {
                        MockInstanceTaxonomy.this.nodesWithoutChildren--;
                    }
                    if (MockInstanceTaxonomy.this.parentMap.get(this).isEmpty()) {
                        MockInstanceTaxonomy.this.nodesWithoutParent--;
                    }
                    MockInstanceTaxonomy.this.parentMap.get(this).add(parent);
                    MockInstanceTaxonomy.this.childrenMap.get(parent).add(this);
                }
            }
        }

        @Override
        public void addDirectInstance(InstanceNode<T, I> instance) {
            assert (this != MockInstanceTaxonomy.this.getBottomNode());
            if (this != MockInstanceTaxonomy.this.getTopNode()) {
                if (this.instances.isEmpty()) {
                    MockInstanceTaxonomy.this.instancesWithoutType--;
                }
                MockInstanceTaxonomy.this.instanceTypeMap.get(instance).add(this);
                this.instances.add(instance);
            }
        }

        private void computeSuccessors(TypeNode<T, I> node, Set<TypeNode<T, I>> successors, DepthFirstSearch.Direction dir) {
            for (TypeNode succ : dir == DepthFirstSearch.Direction.UP ? node.getDirectSuperNodes() : node.getDirectSubNodes()) {
                successors.add(succ);
                this.computeSuccessors(succ, successors, dir);
            }
        }

        @Override
        public void addMembers(Collection<T> members) {
            for (ElkObject member : members) {
                this.members.add(member);
                MockInstanceTaxonomy.this.typeIndex.put(member, this);
            }
        }
    }

    protected abstract class MockNode<O extends ElkObject>
    implements Node<O> {
        final SortedSet<O> members;

        MockNode(Collection<O> members, Comparator<O> cmp) {
            this.members = new TreeSet<O>(cmp);
            this.members.addAll(members);
        }

        public Set<O> getMembers() {
            return this.members;
        }

        public O getCanonicalMember() {
            return (O)(this.members.isEmpty() ? null : (ElkObject)this.members.iterator().next());
        }

        protected abstract void addMembers(Collection<O> var1);

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ElkObject member : this.members) {
                builder.append(OwlFunctionalStylePrinter.toString((ElkObject)member) + ",");
            }
            return builder.toString();
        }
    }

    static interface MutableTypeNode<T extends ElkObject, I extends ElkObject>
    extends TypeNode<T, I> {
        public void addDirectInstance(InstanceNode<T, I> var1);

        public void addDirectParent(TypeNode<T, I> var1);

        public void addMembers(Collection<T> var1);
    }
}

