/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.DepthFirstSearch;
import org.semanticweb.elk.reasoner.taxonomy.InvalidTaxonomyException;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeVisitor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyValidator;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class BasicTaxonomyValidator<T extends ElkObject>
implements TaxonomyValidator<T> {
    private final List<TaxonomyNodeVisitor<T>> visitors_ = new ArrayList<TaxonomyNodeVisitor<T>>();

    public BasicTaxonomyValidator<T> add(TaxonomyNodeVisitor<T> visitor) {
        this.visitors_.add(visitor);
        return this;
    }

    @Override
    public void validate(Taxonomy<T> taxonomy) throws InvalidTaxonomyException {
        DepthFirstSearch dfs = new DepthFirstSearch();
        dfs.run(taxonomy.getBottomNode(), DepthFirstSearch.Direction.UP, new TaxonomyNodeVisitor<T>(){

            public void visit(TaxonomyNode<T> node, List<TaxonomyNode<T>> pathFromStart) throws InvalidTaxonomyException {
                for (TaxonomyNodeVisitor visitor : BasicTaxonomyValidator.this.visitors_) {
                    visitor.visit(node, pathFromStart);
                }
            }
        });
    }
}

