/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;
import org.semanticweb.elk.reasoner.stages.ContextSaturationFlagCheckingStage;
import org.semanticweb.elk.reasoner.taxonomy.BasicTaxonomyValidator;
import org.semanticweb.elk.reasoner.taxonomy.InvalidTaxonomyException;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyAcyclicityAndReductionValidator;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyLinkConsistencyVisitor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeDisjointnessVisitor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeIndexConsistencyVisitor;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;

public class ValidateTaxonomyStage
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(ContextSaturationFlagCheckingStage.class);
    private final Taxonomy<ElkClass> taxonomy_;

    public ValidateTaxonomyStage(AbstractReasonerState reasoner) {
        this.taxonomy_ = reasoner.classTaxonomyState.getTaxonomy();
    }

    @Override
    public String getName() {
        return "Checking validity of class taxonomy";
    }

    @Override
    public void execute() throws ElkException {
        try {
            if (this.taxonomy_ != null) {
                BasicTaxonomyValidator<ElkClass> validator = new BasicTaxonomyValidator<ElkClass>().add(new TaxonomyNodeDisjointnessVisitor<ElkClass>(this.taxonomy_)).add(new TaxonomyLinkConsistencyVisitor()).add(new TaxonomyNodeIndexConsistencyVisitor<ElkClass>(this.taxonomy_));
                validator.validate(this.taxonomy_);
                new TaxonomyAcyclicityAndReductionValidator<ElkClass>().validate(this.taxonomy_);
            }
        }
        catch (InvalidTaxonomyException e) {
            LOGGER_.error((Object)"Invalid taxonomy", (Throwable)e);
            throw e;
        }
    }
}

