/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DirectIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedSubClassOfAxiom;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.Propagation;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.LinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class SaturationGraphValidationStage
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(SaturationGraphValidationStage.class);
    private final OntologyIndex index_;
    private final ClassExpressionValidator iceValidator_ = new ClassExpressionValidator();
    private final ContextValidator contextValidator_ = new ContextValidator();
    private final ContextRuleValidator ruleValidator_ = new ContextRuleValidator();

    public SaturationGraphValidationStage(AbstractReasonerState reasoner) {
        this.index_ = reasoner.ontologyIndex;
    }

    @Override
    public String getName() {
        return "Saturation graph validation";
    }

    @Override
    public void execute() {
        for (IndexedClassExpression ice : this.index_.getIndexedClassExpressions()) {
            this.iceValidator_.add(ice);
        }
        while (this.iceValidator_.validate() || this.contextValidator_.validate()) {
        }
    }

    private class ContextRuleValidator
    implements RuleApplicationVisitor {
        private ContextRuleValidator() {
        }

        public void visit(IndexedClass.OwlThingContextInitializationRule owlThingContextInitializationRule, BasicSaturationStateWriter writer, Context context) {
        }

        public void visit(IndexedDisjointnessAxiom.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            for (IndexedDisjointnessAxiom axiom : thisCompositionRule.getDisjointnessAxioms()) {
                if (!axiom.occurs()) {
                    LOGGER_.error((Object)("Dead disjointness axiom: " + axiom));
                }
                for (IndexedClassExpression ice : axiom.getDisjointMembers()) {
                    SaturationGraphValidationStage.this.iceValidator_.checkNew(ice);
                }
            }
        }

        public void visit(IndexedObjectComplementOf.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            SaturationGraphValidationStage.this.iceValidator_.checkNew(thisCompositionRule.getNegation());
        }

        public void visit(IndexedObjectIntersectionOf.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            for (Map.Entry entry : thisCompositionRule.getConjunctionsByConjunct().entrySet()) {
                SaturationGraphValidationStage.this.iceValidator_.checkNew((IndexedClassExpression)entry.getKey());
                SaturationGraphValidationStage.this.iceValidator_.checkNew((IndexedClassExpression)entry.getValue());
            }
        }

        public void visit(IndexedSubClassOfAxiom.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            for (IndexedClassExpression ice : thisCompositionRule.getToldSuperclasses()) {
                SaturationGraphValidationStage.this.iceValidator_.checkNew(ice);
            }
        }

        public void visit(IndexedObjectSomeValuesFrom.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            for (IndexedClassExpression ice : thisCompositionRule.getNegativeExistentials()) {
                SaturationGraphValidationStage.this.iceValidator_.checkNew(ice);
            }
        }

        public void visit(IndexedObjectUnionOf.ThisCompositionRule thisCompositionRule, BasicSaturationStateWriter writer, Context context) {
            for (IndexedClassExpression ice : thisCompositionRule.getDisjunctions()) {
                SaturationGraphValidationStage.this.iceValidator_.checkNew(ice);
            }
        }

        public void visit(IndexedDisjointnessAxiom.ThisContradictionRule thisContradictionRule, BasicSaturationStateWriter writer, Context context) {
        }

        public void visit(ForwardLink.ThisBackwardLinkRule thisBackwardLinkRule, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
            for (IndexedPropertyChain prop : thisBackwardLinkRule.getForwardLinksByObjectProperty().keySet()) {
                for (Context context : thisBackwardLinkRule.getForwardLinksByObjectProperty().get((Object)prop)) {
                    SaturationGraphValidationStage.this.contextValidator_.add(context);
                }
            }
        }

        public void visit(Propagation.ThisBackwardLinkRule thisBackwardLinkRule, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
            for (IndexedPropertyChain prop : thisBackwardLinkRule.getPropagationsByObjectProperty().keySet()) {
                for (IndexedClassExpression ice : thisBackwardLinkRule.getPropagationsByObjectProperty().get((Object)prop)) {
                    SaturationGraphValidationStage.this.iceValidator_.checkNew(ice);
                }
            }
        }

        public void visit(Contradiction.ContradictionBackwardLinkRule bottomBackwardLinkRule, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
        }

        public void visit(DirectIndex.ContextRootInitializationRule rootInitRule, BasicSaturationStateWriter writer, Context context) {
        }
    }

    private class ContextValidator {
        private final Queue<Context> toValidate_ = new LinkedList<Context>();
        private final Set<Context> cache_ = new ArrayHashSet();

        private ContextValidator() {
        }

        void add(Context context) {
            if (this.cache_.add(context)) {
                this.toValidate_.add(context);
            }
        }

        boolean validate() {
            Context context;
            if (this.toValidate_.isEmpty()) {
                return false;
            }
            while ((context = this.toValidate_.poll()) != null) {
                this.validate(context);
            }
            return true;
        }

        private void validate(Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Validating context for " + context.getRoot()));
            }
            IndexedClassExpression root = context.getRoot();
            SaturationGraphValidationStage.this.iceValidator_.checkNew(root);
            if (root.getContext() != context) {
                LOGGER_.error((Object)("Invalid root for " + context));
            }
            for (IndexedClassExpression subsumer : context.getSubsumers()) {
                SaturationGraphValidationStage.this.iceValidator_.checkNew(subsumer);
            }
            for (IndexedPropertyChain prop : context.getBackwardLinksByObjectProperty().keySet()) {
                for (Context linkedContext : context.getBackwardLinksByObjectProperty().get((Object)prop)) {
                    this.add(linkedContext);
                }
            }
            for (LinkRule rule = context.getBackwardLinkRuleHead(); rule != null; rule = (LinkRule)rule.next()) {
                rule.accept((RuleApplicationVisitor)SaturationGraphValidationStage.this.ruleValidator_, null, null);
            }
        }
    }

    private class ClassExpressionValidator {
        private final Queue<IndexedClassExpression> toValidate_ = new LinkedList<IndexedClassExpression>();
        private final Set<IndexedClassExpression> cache_ = new ArrayHashSet();

        private ClassExpressionValidator() {
        }

        boolean add(IndexedClassExpression ice) {
            if (this.cache_.add(ice)) {
                this.toValidate_.add(ice);
                return true;
            }
            return false;
        }

        void checkNew(IndexedClassExpression ice) {
            if (this.add(ice)) {
                LOGGER_.error((Object)("Unexpected reachable class expression: " + ice + ", " + ice.printOccurrenceNumbers()));
            }
        }

        boolean validate() {
            IndexedClassExpression ice;
            if (this.toValidate_.isEmpty()) {
                return false;
            }
            while ((ice = this.toValidate_.poll()) != null) {
                this.validate(ice);
            }
            return true;
        }

        private void validate(IndexedClassExpression ice) {
            Context context;
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Validating class expression " + ice));
            }
            if (!ice.occurs()) {
                LOGGER_.error((Object)("Dead class expression: " + ice));
            }
            if ((context = ice.getContext()) != null) {
                SaturationGraphValidationStage.this.contextValidator_.add(context);
            }
            for (LinkRule rule = ice.getCompositionRuleHead(); rule != null; rule = (LinkRule)rule.next()) {
                rule.accept((RuleApplicationVisitor)SaturationGraphValidationStage.this.ruleValidator_, null, null);
            }
        }
    }
}

