/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.VerifySymmetricPropertySaturation;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;

public class SaturatedPropertyChainCheckingStage
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(SaturatedPropertyChainCheckingStage.class);
    private final OntologyIndex index_;

    public SaturatedPropertyChainCheckingStage(AbstractReasonerState reasoner) {
        this.index_ = reasoner.ontologyIndex;
    }

    @Override
    public String getName() {
        return "Checking Saturation for Properties";
    }

    @Override
    public void execute() throws ElkException {
        for (IndexedPropertyChain ipc : this.index_.getIndexedPropertyChains()) {
            VerifySymmetricPropertySaturation.AsymmetricCompositionHook hook = new VerifySymmetricPropertySaturation.AsymmetricCompositionHook(){

                @Override
                public void error(IndexedPropertyChain left, IndexedPropertyChain right, IndexedPropertyChain composition, IndexedPropertyChain computed) {
                    LOGGER_.error((Object)("Composition " + left + " o " + right + " => " + composition + " is computed for " + (left == computed ? left : right) + " but not for " + (left == computed ? right : left)));
                }
            };
            VerifySymmetricPropertySaturation.testLeftCompositions(ipc, hook);
            VerifySymmetricPropertySaturation.testRightCompositions(ipc, hook);
        }
    }
}

