/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.semanticweb.elk.RandomSeedProvider;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionNoInputSaturation;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.ContextCleaningFactory;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationFactory;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class RandomContextResaturationStage
extends AbstractReasonerStage {
    static final Logger LOGGER_ = Logger.getLogger(RandomContextResaturationStage.class);
    private final double RATIO_ = 0.2;

    public RandomContextResaturationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    public String getName() {
        return "Clean and re-saturate random contexts";
    }

    public void executeStage() throws ElkException {
        List<IndexedClassExpression> contexts = this.pickRandomContexts(RandomSeedProvider.VALUE);
        this.initContexts(contexts);
        ContextCleaningFactory cleaningFactory = new ContextCleaningFactory(this.reasoner.saturationState);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"Starting random contexts cleaning");
        }
        ClassExpressionNoInputSaturation cleaning = new ClassExpressionNoInputSaturation(this.reasoner.getProcessExecutor(), this.reasoner.getNumberOfWorkers(), this.reasoner.getProgressMonitor(), (RuleApplicationFactory)cleaningFactory, ContextModificationListener.DUMMY);
        cleaning.process();
        this.initContexts(contexts);
        RuleApplicationFactory resatFactory = new RuleApplicationFactory(this.reasoner.saturationState);
        ClassExpressionNoInputSaturation saturation = new ClassExpressionNoInputSaturation(this.reasoner.getProcessExecutor(), this.reasoner.getNumberOfWorkers(), this.reasoner.getProgressMonitor(), resatFactory, ContextModificationListener.DUMMY);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"Starting random contexts resaturation");
        }
        saturation.process();
        this.markAllContextsAsSaturated();
    }

    private void initContexts(Collection<IndexedClassExpression> contexts) {
        for (IndexedClassExpression ice : contexts) {
            if (ice.getContext() == null) continue;
            this.reasoner.saturationState.getExtendedWriter(ConclusionVisitor.DUMMY).initContext(ice.getContext());
        }
    }

    private List<IndexedClassExpression> pickRandomContexts(long seed) {
        Random rnd = new Random(seed);
        ArrayList<IndexedClassExpression> contexts = new ArrayList<IndexedClassExpression>();
        Collection ices = this.reasoner.ontologyIndex.getIndexedClassExpressions();
        int number = Math.max(1, (int)((double)ices.size() * 0.2));
        ArrayHashSet indexes = new ArrayHashSet(number);
        while (indexes.size() < number) {
            indexes.add(rnd.nextInt(ices.size()));
        }
        int i = 0;
        for (IndexedClassExpression ice : ices) {
            if (indexes.contains(i)) {
                if (ice.getContext() != null) {
                    this.reasoner.saturationState.getWriter(ConclusionVisitor.DUMMY).markAsNotSaturated(ice.getContext());
                }
                contexts.add(ice);
            }
            ++i;
        }
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Random contexts picked: " + contexts));
        }
        return contexts;
    }

    public boolean isCompleted() {
        return false;
    }

    public Iterable<ReasonerStage> getPreStages() {
        return Collections.emptyList();
    }

    public void printInfo() {
    }
}

