/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.EnumerateContextsStage;
import org.semanticweb.elk.reasoner.stages.IncrementalDeletionInitializationStage;
import org.semanticweb.elk.reasoner.stages.PostProcessingStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.stages.SimpleStageExecutor;
import org.semanticweb.elk.util.collections.HashListMultimap;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.logging.ElkTimer;

public class PostProcessingStageExecutor
extends SimpleStageExecutor {
    static final Multimap<Class<?>, Class<?>> postProcesingMap = new HashListMultimap();

    public void execute(ReasonerStage stage) throws ElkException {
        super.execute(stage);
        try {
            for (PostProcessingStage ppStage : this.instantiate(postProcesingMap.get(stage.getClass()), ((AbstractReasonerStage)stage).reasoner)) {
                ElkTimer.getNamedTimer((String)ppStage.getName()).start();
                ppStage.execute();
                ElkTimer.getNamedTimer((String)ppStage.getName()).stop();
            }
        }
        catch (Exception e) {
            throw new ElkRuntimeException((Throwable)e);
        }
    }

    private Collection<PostProcessingStage> instantiate(Collection<Class<?>> collection, AbstractReasonerState reasoner) throws Exception {
        ArrayList<PostProcessingStage> stages = new ArrayList<PostProcessingStage>(1);
        for (Class<?> stageClass : collection) {
            Constructor<?> constructor = stageClass.getConstructor(AbstractReasonerState.class);
            PostProcessingStage stage = (PostProcessingStage)constructor.newInstance(reasoner);
            stages.add(stage);
        }
        return stages;
    }

    static {
        postProcesingMap.add(IncrementalDeletionInitializationStage.class, EnumerateContextsStage.class);
    }
}

