/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;
import org.semanticweb.elk.util.collections.ArrayHashSet;

public class ContextSaturationFlagCheckingStage
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(ContextSaturationFlagCheckingStage.class);
    private final Collection<IndexedClassExpression> classes_;
    private final Set<IndexedClassExpression> nonSaturated_;

    public ContextSaturationFlagCheckingStage(AbstractReasonerState reasoner) {
        this.classes_ = reasoner.ontologyIndex.getIndexedClassExpressions();
        this.nonSaturated_ = new ArrayHashSet(reasoner.saturationState.getNotSaturatedContexts().size());
        this.nonSaturated_.addAll(reasoner.saturationState.getNotSaturatedContexts());
    }

    @Override
    public String getName() {
        return "Checking context saturation flag";
    }

    @Override
    public void execute() throws ElkException {
        for (IndexedClassExpression ice : this.classes_) {
            if (ice.getContext() == null) continue;
            if (ice.getContext().isSaturated() && this.nonSaturated_.contains(ice)) {
                LOGGER_.error((Object)("Context " + ice + " IS saturated but contained in the not saturated queue"));
            }
            if (ice.getContext().isSaturated() || this.nonSaturated_.contains(ice)) continue;
            LOGGER_.error((Object)("Context " + ice + " is NOT saturated and NOT contained in the not saturated queue"));
        }
    }
}

