/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;

public class CheckContextInvariants
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(CheckContextInvariants.class);
    private final AbstractReasonerState reasoner_;

    public CheckContextInvariants(AbstractReasonerState reasoner) {
        this.reasoner_ = reasoner;
    }

    @Override
    public String getName() {
        return "Checking subsumers of classes for modified taxonomy nodes";
    }

    @Override
    public void execute() throws ElkException {
        for (Context context : this.reasoner_.saturationState.getContexts()) {
            Conclusion conclusion;
            if (!context.getSubsumers().contains(context.getRoot())) {
                LOGGER_.error((Object)(context.getRoot() + (context.isSaturated() ? " [saturated]" : " [modified]") + ": not a subsumer of itself"));
            }
            if ((conclusion = context.takeToDo()) == null) continue;
            LOGGER_.error((Object)(context.getRoot() + ": non-empty TODO: " + conclusion));
        }
    }
}

