/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.BasePostProcessingStage;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Multimap;

public class CheckCleaningStage
extends BasePostProcessingStage {
    private static final Logger LOGGER_ = Logger.getLogger(CheckCleaningStage.class);
    private final AbstractReasonerState reasoner_;

    public CheckCleaningStage(AbstractReasonerState reasoner) {
        this.reasoner_ = reasoner;
    }

    @Override
    public String getName() {
        return "Checking that unsaturated contexts are clean";
    }

    @Override
    public void execute() throws ElkException {
        Context context;
        ArrayHashSet cleanedContexts = new ArrayHashSet(1024);
        for (IndexedClassExpression ice : this.reasoner_.saturationState.getNotSaturatedContexts()) {
            context = ice.getContext();
            if (context == null) {
                LOGGER_.error((Object)("Context removed for " + ice));
                continue;
            }
            cleanedContexts.add(context);
            if (ice.getContext().getSubsumers().size() <= 0) continue;
            LOGGER_.error((Object)("Context not cleaned: " + ice.toString() + "\n" + ice.getContext().getSubsumers().size() + " subsumers: " + ice.getContext().getSubsumers()));
        }
        for (IndexedClassExpression ice : this.reasoner_.getIndexedClassExpressions()) {
            context = ice.getContext();
            if (context == null) continue;
            Multimap backwardLinks = context.getBackwardLinksByObjectProperty();
            for (IndexedPropertyChain ipc : backwardLinks.keySet()) {
                for (Context target : backwardLinks.get((Object)ipc)) {
                    if (!cleanedContexts.contains(target)) continue;
                    LOGGER_.error((Object)("Backward link in " + context + " via property " + ipc + " to cleaned context " + target));
                }
            }
        }
    }
}

