/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectsCreator;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.PropertyHierarchyCompositionComputation;
import org.semanticweb.elk.reasoner.saturation.properties.PropertyHierarchyCompositionComputationFactory;
import org.semanticweb.elk.reasoner.saturation.properties.ReflexivePropertyComputation;
import org.semanticweb.elk.reasoner.saturation.properties.ReflexivePropertyComputationFactory;
import org.semanticweb.elk.reasoner.saturation.properties.VerifySymmetricPropertySaturation;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public class IndexedPropertyChainSaturationTest {
    @Test
    @Ignore
    public void testPropertyCompositionSymmetry() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        IndexedObjectProperty R1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R1")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty R2 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R2")), new IndexedPropertyChain[]{R1}, new IndexedObjectProperty[0], false);
        IndexedObjectProperty R3 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R3")), new IndexedPropertyChain[]{R2}, new IndexedObjectProperty[0], false);
        IndexedPropertyChain R1R2 = IndexedObjectsCreator.createIndexedChain(R1, (IndexedPropertyChain)R2, new IndexedObjectProperty[]{R1, R3});
        IndexedPropertyChain R1R3 = IndexedObjectsCreator.createIndexedChain(R1, (IndexedPropertyChain)R3, new IndexedObjectProperty[]{R1, R3});
        IndexedPropertyChain R2R3 = IndexedObjectsCreator.createIndexedChain(R2, (IndexedPropertyChain)R3, new IndexedObjectProperty[]{R1, R3});
        List<IndexedPropertyChain> chains = Arrays.asList(R1, R2, R3, R1R2, R1R3, R2R3);
        VerifySymmetricPropertySaturation.AsymmetricCompositionHook hook = new VerifySymmetricPropertySaturation.AsymmetricCompositionHook(){

            @Override
            public void error(IndexedPropertyChain left, IndexedPropertyChain right, IndexedPropertyChain composition, IndexedPropertyChain computed) {
                Assert.fail((String)("Composition " + left + " o " + right + " => " + composition + " is computed for " + (left == computed ? left : right) + " but not for " + (left == computed ? right : left)));
            }
        };
        for (int i = 1; i < 10; ++i) {
            Collections.shuffle(chains);
            for (IndexedPropertyChain chain : chains) {
                VerifySymmetricPropertySaturation.testLeftCompositions(chain, hook);
                VerifySymmetricPropertySaturation.testRightCompositions(chain, hook);
            }
        }
    }

    @Test
    public void testCyclicCompositions() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        IndexedObjectProperty H = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/H")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty S3 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/S3")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty S2 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/S2")), new IndexedPropertyChain[0], new IndexedObjectProperty[]{S3}, false);
        IndexedObjectProperty S1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/S1")), new IndexedPropertyChain[0], new IndexedObjectProperty[]{S2}, false);
        IndexedObjectProperty P3 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/P3")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty P2 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/P2")), new IndexedPropertyChain[0], new IndexedObjectProperty[]{P3}, false);
        IndexedObjectProperty P1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/P1")), new IndexedPropertyChain[0], new IndexedObjectProperty[]{P2}, false);
        IndexedObjectProperty R = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R")), new IndexedPropertyChain[]{S3}, new IndexedObjectProperty[]{S1, P1}, false);
        IndexedPropertyChain RR = IndexedObjectsCreator.createIndexedChain(R, (IndexedPropertyChain)R, new IndexedObjectProperty[]{H});
        int maxThreads = Runtime.getRuntime().availableProcessors();
        PropertyHierarchyCompositionComputation computation = new PropertyHierarchyCompositionComputation(Arrays.asList(H, S3, S2, S1, P3, P2, P1, R, RR), new PropertyHierarchyCompositionComputationFactory(), new ComputationExecutor(maxThreads, "test-hierarchy-compositions"), maxThreads, (ProgressMonitor)new DummyProgressMonitor());
        computation.process();
        Assert.assertTrue((boolean)R.getSaturated().getCompositionsByLeftSubProperty().get((Object)R).contains(H));
        Assert.assertTrue((boolean)R.getSaturated().getCompositionsByRightSubProperty().get((Object)R).contains(H));
    }

    @Test
    public void testReflexivity() {
        ElkObjectFactoryImpl factory = new ElkObjectFactoryImpl();
        ArrayList<IndexedObjectProperty> toldReflexive = new ArrayList<IndexedObjectProperty>();
        IndexedObjectProperty t = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/T")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty r1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R1")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], true);
        IndexedObjectProperty r = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/R")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedPropertyChain r1r1 = IndexedObjectsCreator.createIndexedChain(r1, (IndexedPropertyChain)r1, new IndexedObjectProperty[]{r});
        IndexedPropertyChain rt = IndexedObjectsCreator.createIndexedChain(r, (IndexedPropertyChain)t, new IndexedObjectProperty[0]);
        IndexedObjectProperty u = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/U")), new IndexedPropertyChain[]{rt}, new IndexedObjectProperty[0], false);
        IndexedObjectProperty h = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/H")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], true);
        IndexedObjectProperty h1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/H1")), new IndexedPropertyChain[]{h}, new IndexedObjectProperty[0], false);
        IndexedObjectProperty s = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/S")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedPropertyChain rh1 = IndexedObjectsCreator.createIndexedChain(r, (IndexedPropertyChain)h1, new IndexedObjectProperty[]{s});
        IndexedObjectProperty v1 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/V1")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedObjectProperty v2 = IndexedObjectsCreator.createIndexedObjectProperty(factory.getObjectProperty((ElkIri)new ElkFullIri("http://test.com/V2")), new IndexedPropertyChain[0], new IndexedObjectProperty[0], false);
        IndexedPropertyChain v1v1 = IndexedObjectsCreator.createIndexedChain(v1, (IndexedPropertyChain)v1, new IndexedObjectProperty[]{v2});
        IndexedPropertyChain v2v2 = IndexedObjectsCreator.createIndexedChain(v2, (IndexedPropertyChain)v2, new IndexedObjectProperty[]{v1});
        toldReflexive.addAll(Arrays.asList(r1, h));
        List<IndexedPropertyChain> chains = Arrays.asList(t, r1, r, r1r1, rt, u, h, h1, s, rh1, v1, v2, v1v1, v2v2);
        HashSet<IndexedPropertyChain> correctReflexive = new HashSet<IndexedPropertyChain>(Arrays.asList(r, h, h1, r1, r1r1, rh1, s));
        int maxThreads = Runtime.getRuntime().availableProcessors();
        ReflexivePropertyComputation computation = new ReflexivePropertyComputation(toldReflexive, new ReflexivePropertyComputationFactory(), new ComputationExecutor(maxThreads, "test-reflexivity"), maxThreads, (ProgressMonitor)new DummyProgressMonitor());
        computation.process();
        for (IndexedPropertyChain chain : chains) {
            Assert.assertEquals((String)chain.toString(), (Object)correctReflexive.contains(chain), (Object)this.isReflexive(chain));
        }
    }

    private boolean isReflexive(IndexedPropertyChain chain) {
        return (Boolean)chain.accept((IndexedPropertyChainVisitor)new IndexedPropertyChainVisitor<Boolean>(){

            public Boolean visit(IndexedObjectProperty prop) {
                return prop.isToldReflexive() || prop.getSaturated() != null && prop.getSaturated().isDerivedReflexive();
            }

            public Boolean visit(IndexedBinaryPropertyChain chain) {
                return chain.getSaturated() != null && chain.getSaturated().isDerivedReflexive();
            }
        });
    }
}

