/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DirectIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.MainAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainFilter;
import org.semanticweb.elk.reasoner.saturation.properties.CompositionClosure;
import org.semanticweb.elk.reasoner.saturation.properties.ReducingCompositionClosure;

public class CompositionClosureTest {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    @Test
    public void testReplaceByToldSuperPropertiesAndEliminateImplied() throws ElkException, InterruptedException {
        DirectIndex index = new DirectIndex();
        MainAxiomIndexerVisitor indexer = new MainAxiomIndexerVisitor((ModifiableOntologyIndex)index, true);
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":r"));
        ElkObjectProperty s = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":s"));
        ElkObjectProperty h1 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h1"));
        ElkObjectProperty h2 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h2"));
        ElkObjectProperty h3 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h3"));
        ElkObjectProperty h4 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h4"));
        ElkObjectProperty h5 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h5"));
        ElkObjectPropertyChain ros = this.objectFactory.getObjectPropertyChain(Arrays.asList(r, s));
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h1).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h2).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h3).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h3, (ElkObjectPropertyExpression)h4).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h4, (ElkObjectPropertyExpression)h2).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h2, (ElkObjectPropertyExpression)h5).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h5, (ElkObjectPropertyExpression)h1).accept((ElkAxiomVisitor)indexer);
        IndexedObjectCache objectCache = index.getIndexedObjectCache();
        IndexObjectConverter converter = new IndexObjectConverter((IndexedClassExpressionFilter)objectCache, (IndexedPropertyChainFilter)objectCache);
        IndexedPropertyChain ih1 = (IndexedPropertyChain)h1.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedPropertyChain ih2 = (IndexedPropertyChain)h2.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedPropertyChain ih3 = (IndexedPropertyChain)h3.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedBinaryPropertyChain iros = (IndexedBinaryPropertyChain)ros.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        CompositionClosure closure = new CompositionClosure(iros);
        HashSet compositions = new HashSet(5);
        closure.applyTo(compositions);
        Assert.assertTrue((boolean)compositions.contains(ih1));
        Assert.assertTrue((boolean)compositions.contains(ih2));
        Assert.assertTrue((boolean)compositions.contains(ih3));
        Assert.assertEquals((long)3L, (long)compositions.size());
        compositions.clear();
        ReducingCompositionClosure reducingClosure = new ReducingCompositionClosure(iros);
        reducingClosure.applyTo(compositions);
        Assert.assertTrue((boolean)compositions.contains(ih3));
        Assert.assertEquals((long)1L, (long)compositions.size());
    }

    @Test
    public void testEquivalentProperties() throws ElkException, InterruptedException {
        DirectIndex index = new DirectIndex();
        MainAxiomIndexerVisitor indexer = new MainAxiomIndexerVisitor((ModifiableOntologyIndex)index, true);
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":r"));
        ElkObjectProperty s = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":s"));
        ElkObjectProperty h1 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h1"));
        ElkObjectProperty h2 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h2"));
        ElkObjectProperty h3 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h3"));
        ElkObjectProperty h4 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h4"));
        ElkObjectProperty h5 = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":h5"));
        ElkObjectPropertyChain ros = this.objectFactory.getObjectPropertyChain(Arrays.asList(r, s));
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h1).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h2).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h3).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ros, (ElkObjectPropertyExpression)h4).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h3, (ElkObjectPropertyExpression)h4).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h2, (ElkObjectPropertyExpression)h5).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h5, (ElkObjectPropertyExpression)h3).accept((ElkAxiomVisitor)indexer);
        this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)h3, (ElkObjectPropertyExpression)h2).accept((ElkAxiomVisitor)indexer);
        IndexedObjectCache objectCache = index.getIndexedObjectCache();
        IndexObjectConverter converter = new IndexObjectConverter((IndexedClassExpressionFilter)objectCache, (IndexedPropertyChainFilter)objectCache);
        IndexedPropertyChain ih1 = (IndexedPropertyChain)h1.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedPropertyChain ih2 = (IndexedPropertyChain)h2.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedPropertyChain ih3 = (IndexedPropertyChain)h3.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        IndexedBinaryPropertyChain iros = (IndexedBinaryPropertyChain)ros.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        ReducingCompositionClosure closure = new ReducingCompositionClosure(iros);
        HashSet compositions = new HashSet(5);
        closure.applyTo(compositions);
        Assert.assertTrue((boolean)compositions.contains(ih1));
        Assert.assertEquals((long)2L, (long)compositions.size());
        Assert.assertTrue((compositions.contains(ih2) || compositions.contains(ih3) ? 1 : 0) != 0);
    }
}

