/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.junit.Test;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ChangeIndexingProcessor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DirectIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkAxiomIndexingVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.MainAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainFilter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.SaturationStateImpl;
import org.semanticweb.elk.reasoner.saturation.TestClassExpressionSaturation;
import org.semanticweb.elk.reasoner.saturation.TestPropertySaturation;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionInsertionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.BasicCompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;

public class ConcurrentSaturatorTest
extends TestCase {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    public ConcurrentSaturatorTest(String testName) {
        super(testName);
    }

    @Test
    public void testExistentials() throws InterruptedException, ExecutionException {
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("R"));
        ElkObjectProperty s = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("S"));
        DirectIndex index = new DirectIndex();
        ComputationExecutor executor = new ComputationExecutor(16, "test");
        ChangeIndexingProcessor inserter = new ChangeIndexingProcessor((ElkAxiomIndexingVisitor)new MainAxiomIndexerVisitor((ModifiableOntologyIndex)index, true));
        inserter.visit((ElkAxiom)this.objectFactory.getEquivalentClassesAxiom((ElkClassExpression)b, (ElkClassExpression)c, new ElkClassExpression[0]));
        inserter.visit((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b)));
        inserter.visit((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)c), (ElkClassExpression)d));
        inserter.visit((ElkAxiom)this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)r, (ElkObjectPropertyExpression)s));
        IndexedObjectCache objectCache = index.getIndexedObjectCache();
        IndexObjectConverter converter = new IndexObjectConverter((IndexedClassExpressionFilter)objectCache, (IndexedPropertyChainFilter)objectCache);
        IndexedClassExpression A = (IndexedClassExpression)a.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression D = (IndexedClassExpression)d.accept((ElkClassExpressionVisitor)converter);
        IndexedPropertyChain R = (IndexedPropertyChain)r.accept((ElkSubObjectPropertyExpressionVisitor)converter);
        TestPropertySaturation propertySaturation = new TestPropertySaturation(executor, 16, (OntologyIndex)index);
        TestClassExpressionSaturation classExpressionSaturation = new TestClassExpressionSaturation(executor, 16, (OntologyIndex)index);
        propertySaturation.start();
        propertySaturation.submit(R);
        propertySaturation.finish();
        classExpressionSaturation.start();
        classExpressionSaturation.submit(new SaturationJob(A));
        classExpressionSaturation.finish();
        ConcurrentSaturatorTest.assertTrue((String)"A contains D", (boolean)A.getContext().getSubsumers().contains(D));
    }

    @Test
    public void testConjunctions() throws InterruptedException, ExecutionException {
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        DirectIndex index = new DirectIndex();
        ComputationExecutor executor = new ComputationExecutor(16, "test");
        ChangeIndexingProcessor inserter = new ChangeIndexingProcessor((ElkAxiomIndexingVisitor)new MainAxiomIndexerVisitor((ModifiableOntologyIndex)index, true));
        inserter.visit((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b));
        inserter.visit((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)c));
        inserter.visit((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)b, (ElkClassExpression)c, new ElkClassExpression[0]), (ElkClassExpression)d));
        IndexedObjectCache objectCache = index.getIndexedObjectCache();
        IndexObjectConverter converter = new IndexObjectConverter((IndexedClassExpressionFilter)objectCache, (IndexedPropertyChainFilter)objectCache);
        IndexedClassExpression A = (IndexedClassExpression)a.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression B = (IndexedClassExpression)b.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression C = (IndexedClassExpression)c.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression D = (IndexedClassExpression)d.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression I = (IndexedClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)b, (ElkClassExpression)c, new ElkClassExpression[0]).accept((ElkClassExpressionVisitor)converter);
        TestClassExpressionSaturation classExpressionSaturation = new TestClassExpressionSaturation(executor, 16, (OntologyIndex)index);
        classExpressionSaturation.start();
        classExpressionSaturation.submit(new SaturationJob(A));
        classExpressionSaturation.finish();
        Context context = A.getContext();
        ConcurrentSaturatorTest.assertTrue((String)"A contains A", (boolean)context.getSubsumers().contains(A));
        ConcurrentSaturatorTest.assertTrue((String)"A contains B", (boolean)context.getSubsumers().contains(B));
        ConcurrentSaturatorTest.assertTrue((String)"A contains C", (boolean)context.getSubsumers().contains(C));
        ConcurrentSaturatorTest.assertTrue((String)"A contains I", (boolean)context.getSubsumers().contains(I));
        ConcurrentSaturatorTest.assertTrue((String)"A contains D", (boolean)context.getSubsumers().contains(D));
    }

    public void testContextLinking() {
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        DirectIndex index = new DirectIndex();
        SaturationStateImpl state = new SaturationStateImpl((OntologyIndex)index);
        IndexedObjectCache objectCache = index.getIndexedObjectCache();
        IndexObjectConverter converter = new IndexObjectConverter((IndexedClassExpressionFilter)objectCache, (IndexedPropertyChainFilter)objectCache);
        IndexedClassExpression A = (IndexedClassExpression)a.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression B = (IndexedClassExpression)b.accept((ElkClassExpressionVisitor)converter);
        IndexedClassExpression C = (IndexedClassExpression)c.accept((ElkClassExpressionVisitor)converter);
        ExtendedSaturationStateWriter writer = state.getExtendedWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY, (RuleApplicationVisitor)new BasicCompositionRuleApplicationVisitor(), (ConclusionVisitor)new ConclusionInsertionVisitor(), false);
        Context cA = writer.getCreateContext(A);
        Context cB = writer.getCreateContext(B);
        Context cC = writer.getCreateContext(C);
        ConcurrentSaturatorTest.assertEquals((int)3, (int)this.getRoots(state.getContexts()).size());
        cC.removeLinks();
        ConcurrentSaturatorTest.assertEquals((int)2, (int)this.getRoots(state.getContexts()).size());
        cA.removeLinks();
        ConcurrentSaturatorTest.assertEquals((int)1, (int)this.getRoots(state.getContexts()).size());
        cB.removeLinks();
        ConcurrentSaturatorTest.assertTrue((boolean)state.getContexts().isEmpty());
    }

    private Collection<IndexedClassExpression> getRoots(Iterable<Context> contexts) {
        ArrayList<IndexedClassExpression> roots = new ArrayList<IndexedClassExpression>();
        for (Context c : contexts) {
            roots.add(c.getRoot());
        }
        return roots;
    }
}

