/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;

public class IndexedObjectsCreator {
    public static IndexedObjectProperty createIndexedObjectProperty(ElkObjectProperty prop, IndexedPropertyChain[] toldSubs, IndexedObjectProperty[] toldSupers, boolean reflexive) {
        IndexedObjectProperty property = new IndexedObjectProperty(prop);
        for (IndexedPropertyChain indexedPropertyChain : toldSubs) {
            property.addToldSubPropertyChain(indexedPropertyChain);
            indexedPropertyChain.addToldSuperObjectProperty(property);
        }
        for (IndexedPropertyChain indexedPropertyChain : toldSupers) {
            property.addToldSuperObjectProperty((IndexedObjectProperty)indexedPropertyChain);
            indexedPropertyChain.addToldSubPropertyChain((IndexedPropertyChain)property);
        }
        if (reflexive) {
            property.reflexiveAxiomOccurrenceNo = 1;
        }
        return property;
    }

    public static IndexedPropertyChain createIndexedChain(IndexedObjectProperty left, IndexedPropertyChain right, IndexedObjectProperty[] toldSupers) {
        IndexedBinaryPropertyChain chain = new IndexedBinaryPropertyChain(left, right);
        for (IndexedObjectProperty sup : toldSupers) {
            chain.addToldSuperObjectProperty(sup);
            sup.addToldSubPropertyChain((IndexedPropertyChain)chain);
        }
        left.addLeftChain(chain);
        right.addRightChain(chain);
        return chain;
    }
}

