/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.LinkedList;
import java.util.Queue;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangeType;

public class TestChangesLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    private final Queue<ElkAxiom> axioms_ = new LinkedList<ElkAxiom>();
    private final Queue<Boolean> changes_ = new LinkedList<Boolean>();

    public TestChangesLoader() {
    }

    public TestChangesLoader(Iterable<ElkAxiom> axioms, IncrementalChangeType type) {
        for (ElkAxiom axiom : axioms) {
            switch (type) {
                case ADD: {
                    this.add(axiom);
                    break;
                }
                case DELETE: {
                    this.remove(axiom);
                }
            }
        }
    }

    public TestChangesLoader(Iterable<ElkAxiom> additions, Iterable<ElkAxiom> deletions) {
        for (ElkAxiom addition : additions) {
            this.add(addition);
        }
        for (ElkAxiom deletion : deletions) {
            this.remove(deletion);
        }
    }

    public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        ElkAxiom axiom;
        while ((axiom = this.axioms_.poll()) != null) {
            boolean isAdded = this.changes_.poll();
            if (isAdded) {
                axiomInserter.visit(axiom);
                continue;
            }
            axiomDeleter.visit(axiom);
        }
    }

    public boolean isLoadingFinished() {
        return this.axioms_.isEmpty();
    }

    public TestChangesLoader add(ElkAxiom axiom) {
        this.axioms_.add(axiom);
        this.changes_.add(true);
        return this;
    }

    public TestChangesLoader remove(ElkAxiom axiom) {
        this.axioms_.add(axiom);
        this.changes_.add(false);
        return this;
    }
}

