/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.IncrementalChange;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangeType;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.stages.SimpleStageExecutor;

public interface RandomWalkRunnerIO<T> {
    public void revertChanges(Reasoner var1, IncrementalChange<T> var2);

    public void printAxiom(T var1, Logger var2, Level var3);

    public Reasoner createReasoner(Iterable<T> var1);

    public void loadChanges(Reasoner var1, IncrementalChange<T> var2);

    public static class ElkAPIBasedIO
    implements RandomWalkRunnerIO<ElkAxiom> {
        @Override
        public Reasoner createReasoner(Iterable<ElkAxiom> axioms) {
            Reasoner reasoner = TestReasonerUtils.createTestReasoner(new TestChangesLoader(axioms, IncrementalChangeType.ADD), (ReasonerStageExecutor)new SimpleStageExecutor());
            reasoner.setAllowIncrementalMode(false);
            return reasoner;
        }

        @Override
        public void loadChanges(Reasoner reasoner, IncrementalChange<ElkAxiom> change) {
            reasoner.registerAxiomLoader((AxiomLoader)new TestChangesLoader(change.getAdditions(), change.getDeletions()));
        }

        @Override
        public void printAxiom(ElkAxiom axiom, Logger logger, Level level) {
            logger.log((Priority)level, (Object)OwlFunctionalStylePrinter.toString((ElkObject)axiom));
        }

        @Override
        public void revertChanges(Reasoner reasoner, IncrementalChange<ElkAxiom> change) {
            reasoner.registerAxiomLoader((AxiomLoader)new TestChangesLoader(change.getDeletions(), change.getAdditions()));
        }
    }
}

