/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.incremental.RandomWalkIncrementalClassificationRunner;
import org.semanticweb.elk.reasoner.incremental.RandomWalkRunnerIO;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;

public class RandomWalkIncrementalRealizationRunner<T>
extends RandomWalkIncrementalClassificationRunner<T> {
    public RandomWalkIncrementalRealizationRunner(int rounds, int iter, RandomWalkRunnerIO<T> io) {
        super(rounds, iter, io);
    }

    @Override
    protected void printResult(Reasoner reasoner, Logger logger, Level level) throws IOException, ElkException {
        InstanceTaxonomy taxonomy = reasoner.getInstanceTaxonomyQuietly();
        StringWriter writer = new StringWriter();
        TaxonomyPrinter.dumpInstanceTaxomomy((InstanceTaxonomy)taxonomy, (Writer)writer, (boolean)false);
        writer.flush();
        logger.log((Priority)level, (Object)"INSTANCE TAXONOMY");
        logger.log((Priority)level, (Object)writer.getBuffer());
        writer.close();
    }

    @Override
    protected String getResultHash(Reasoner reasoner) throws ElkException {
        InstanceTaxonomy taxonomy = reasoner.getInstanceTaxonomyQuietly();
        return TaxonomyPrinter.getInstanceHashString((InstanceTaxonomy)taxonomy);
    }
}

