/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.junit.Assert;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.incremental.IncrementalChange;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangeTracker;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;
import org.semanticweb.elk.reasoner.incremental.RandomWalkRunnerIO;
import org.semanticweb.elk.reasoner.incremental.RandomWalkTestHook;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.collections.Operations;

public class RandomWalkIncrementalClassificationRunner<T> {
    private static final Logger LOGGER_ = Logger.getLogger(RandomWalkIncrementalClassificationRunner.class);
    private final int maxRounds_;
    private final int iterations_;
    private final RandomWalkRunnerIO<T> io_;

    public RandomWalkIncrementalClassificationRunner(int rounds, int iter, RandomWalkRunnerIO<T> io) {
        this.maxRounds_ = rounds;
        this.iterations_ = iter;
        this.io_ = io;
    }

    public void run(Reasoner reasoner, OnOffVector<T> changingAxioms, List<T> staticAxioms, long seed) throws ElkException, InterruptedException, IOException {
        this.run(reasoner, changingAxioms, staticAxioms, seed, null);
    }

    public void run(Reasoner reasoner, OnOffVector<T> changingAxioms, List<T> staticAxioms, long seed, RandomWalkTestHook hook) throws ElkException, InterruptedException, IOException {
        LinkedList<String> resultHashHistory = new LinkedList<String>();
        reasoner.setAllowIncrementalMode(true);
        String originalTaxonomyHash = this.getResultHash(reasoner);
        int changingAxiomsCount = changingAxioms.size();
        int rounds = this.getNumberOfRounds(changingAxiomsCount);
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Running " + rounds + " rounds with " + this.iterations_ + " random changes"));
        }
        int changeSize = this.getInitialChangeSize(changingAxiomsCount);
        IncrementalChangeTracker<T> tracker = new IncrementalChangeTracker<T>(changingAxioms, changeSize);
        for (int j = 0; j < rounds; ++j) {
            if (LOGGER_.isInfoEnabled()) {
                LOGGER_.info((Object)("Generating " + this.iterations_ + " changes of size: " + changeSize));
            }
            changingAxioms.setAllOn();
            resultHashHistory.add(originalTaxonomyHash);
            for (int i = 0; i < this.iterations_; ++i) {
                IncrementalChange<T> change = tracker.generateNextChange();
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)("Change for round " + (j + 1) + " iteration " + (i + 1)));
                    LOGGER_.trace((Object)"Deleted axioms");
                    this.printCurrentAxioms(change.getDeletions(), Level.TRACE);
                    LOGGER_.trace((Object)"Added axioms");
                    this.printCurrentAxioms(change.getAdditions(), Level.TRACE);
                }
                this.io_.loadChanges(reasoner, change);
                String resultHash = this.getResultHash(reasoner);
                resultHashHistory.add(resultHash);
                if (!LOGGER_.isTraceEnabled()) continue;
                LOGGER_.trace((Object)("Taxonomy hash code for round " + (j + 1) + " iteration " + (i + 1) + ": " + resultHash));
                LOGGER_.trace((Object)"Current axioms");
                this.printCurrentAxioms(Operations.concat(changingAxioms.getOnElements(), staticAxioms), Level.DEBUG);
                this.printResult(reasoner, LOGGER_, Level.TRACE);
            }
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)"Checking the final result");
            }
            String finalResultHash = (String)resultHashHistory.pollLast();
            Reasoner standardReasoner = this.io_.createReasoner(Operations.concat(changingAxioms.getOnElements(), staticAxioms));
            String expectedResultHash = this.getResultHash(standardReasoner);
            if (!expectedResultHash.equals(finalResultHash)) {
                StringWriter writer = new StringWriter();
                try {
                    writer.write("EXPECTED TAXONOMY:\n");
                    this.printResult(standardReasoner, writer);
                    writer.write("\nINCREMENTAL TAXONOMY:\n");
                    this.printResult(reasoner, writer);
                    writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Assert.fail((String)("Seed: " + seed + "\n" + writer.getBuffer().toString()));
            }
            standardReasoner.shutdown();
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)"Reverting the changes");
            }
            while (true) {
                IncrementalChange<T> change = tracker.getChangeHistory().pollLast();
                String expectedHash = (String)resultHashHistory.pollLast();
                if (change == null) break;
                this.io_.revertChanges(reasoner, change);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)"Reverting the next change");
                    LOGGER_.trace((Object)"Adding back:");
                    this.printCurrentAxioms(change.getDeletions(), Level.TRACE);
                    LOGGER_.trace((Object)"Deleting:");
                    this.printCurrentAxioms(change.getAdditions(), Level.TRACE);
                }
                String taxonomyHash = this.getResultHash(reasoner);
                try {
                    Assert.assertEquals((String)("Seed " + seed), (Object)expectedHash, (Object)taxonomyHash);
                }
                catch (AssertionError e) {
                    this.printResult(reasoner, LOGGER_, Level.DEBUG);
                    throw e;
                }
            }
            changeSize *= 2;
        }
    }

    protected void printResult(Reasoner reasoner, Logger logger, Level level) throws IOException, ElkException {
        StringWriter writer = new StringWriter();
        this.printResult(reasoner, writer);
        logger.log((Priority)level, (Object)"CLASS TAXONOMY");
        logger.log((Priority)level, (Object)writer.getBuffer());
        writer.close();
    }

    protected void printResult(Reasoner reasoner, Writer writer) throws IOException, ElkException {
        Taxonomy taxonomy = reasoner.getTaxonomyQuietly();
        TaxonomyPrinter.dumpClassTaxomomy((Taxonomy)taxonomy, (Writer)writer, (boolean)false);
        writer.flush();
    }

    protected String getResultHash(Reasoner reasoner) throws ElkException {
        return TaxonomyPrinter.getHashString((Taxonomy)reasoner.getTaxonomyQuietly());
    }

    private int getInitialChangeSize(int changingAxiomsCount) {
        int result = changingAxiomsCount >> this.maxRounds_;
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    private int getNumberOfRounds(int changingAxiomsCount) {
        return Math.min(this.maxRounds_, 2 * (31 - Integer.numberOfLeadingZeros(changingAxiomsCount)));
    }

    private void printCurrentAxioms(Iterable<T> axioms, Level level) {
        if (LOGGER_.isEnabledFor((Priority)level)) {
            for (T axiom : axioms) {
                this.io_.printAxiom(axiom, LOGGER_, level);
            }
        }
    }
}

