/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class OnOffVector<T>
extends Vector<T> {
    private static final long serialVersionUID = -7521093590463405223L;
    private final Vector<Boolean> onOffValues_;

    public OnOffVector(int size) {
        super(size);
        this.onOffValues_ = new Vector(size);
    }

    @Override
    public boolean add(T element) {
        boolean result = super.add(element);
        if (result) {
            this.onOffValues_.add(true);
        }
        return result;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> collection) {
        boolean result = false;
        for (T element : collection) {
            result |= this.add(element);
        }
        return result;
    }

    public boolean isOn(int index) {
        return this.onOffValues_.get(index);
    }

    public void setAllOn() {
        for (int i = 0; i < this.onOffValues_.size(); ++i) {
            this.onOffValues_.set(i, true);
        }
    }

    public void setAllOff() {
        for (int i = 0; i < this.onOffValues_.size(); ++i) {
            this.onOffValues_.set(i, false);
        }
    }

    public boolean flipOnOff(int index) {
        boolean result = this.onOffValues_.get(index);
        this.onOffValues_.set(index, !result);
        return result;
    }

    public Iterable<T> getOnElements() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int nextOnIndex = 0;
                    {
                        this.findNextOnIndex();
                    }

                    private void findNextOnIndex() {
                        while (this.nextOnIndex < OnOffVector.this.onOffValues_.size() && !((Boolean)OnOffVector.this.onOffValues_.get(this.nextOnIndex)).booleanValue()) {
                            ++this.nextOnIndex;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextOnIndex < OnOffVector.this.onOffValues_.size();
                    }

                    @Override
                    public T next() {
                        Object result = OnOffVector.this.get(this.nextOnIndex);
                        ++this.nextOnIndex;
                        this.findNextOnIndex();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal of elements not supported!");
                    }
                };
            }
        };
    }
}

