/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.PostProcessingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;

public class LowLevelIncrementalTBoxTest {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    @Test
    public void testBasicDeletion() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("R"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)d)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b))).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)d), (ElkClassExpression)c));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)d));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertFalse((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
    }

    @Test
    public void testDeletePositiveExistential() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkClass e = this.objectFactory.getClass((ElkIri)new ElkFullIri(":E"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("R"));
        ElkSubClassOfAxiom posExistential = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)d)).add((ElkAxiom)posExistential).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)e)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)d), (ElkClassExpression)c));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)posExistential);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertFalse((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
    }

    @Test
    public void testDeleteAddConjunction() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkSubClassOfAxiom axAandBsubC = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)a, (ElkClassExpression)b, new ElkClassExpression[0]), (ElkClassExpression)c);
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b)).add((ElkAxiom)axAandBsubC);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axAandBsubC).add((ElkAxiom)axAandBsubC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axAandBsubC).add((ElkAxiom)axAandBsubC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axAandBsubC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axAandBsubC).remove((ElkAxiom)axAandBsubC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axAandBsubC).remove((ElkAxiom)axAandBsubC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().size());
    }

    @Test
    public void testEquivalence() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkEquivalentClassesAxiom axAeqB = this.objectFactory.getEquivalentClassesAxiom((ElkClassExpression)a, (ElkClassExpression)b, new ElkClassExpression[0]);
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)c)).add((ElkAxiom)axAeqB);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)a).getMembers().size());
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axAeqB).add((ElkAxiom)axAeqB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)a).getMembers().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axAeqB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)a).getMembers().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axAeqB).remove((ElkAxiom)axAeqB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)a).getMembers().size());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axAeqB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)a).getMembers().size());
    }

    @Test
    public void testNewClassUnsatisfiable() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)b)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        changeLoader.add((ElkAxiom)this.objectFactory.getDisjointClassesAxiom(Arrays.asList(c, d, c)));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getNode((ElkObject)c));
        Assert.assertNotSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getNode((ElkObject)d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFromForest() throws ElkException, IOException {
        InputStream stream = null;
        String toDelete = "Prefix(test:=<http://www.test.com/schema#>) Ontology(\nSubClassOf(ObjectSomeValuesFrom(<test:has-color> <test:brown>) <test:brown-thing>) \nSubClassOf(<test:green> <test:color>) \n)";
        ElkClass tree = this.objectFactory.getClass((ElkIri)new ElkFullIri("test:tree"));
        ElkClass greenThing = this.objectFactory.getClass((ElkIri)new ElkFullIri("test:green-thing"));
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream("incremental/forest.owl");
            List<ElkAxiom> ontology = this.loadAxioms(stream);
            List<ElkAxiom> deletions = this.loadAxioms(new StringReader(toDelete));
            TestChangesLoader initialLoader = new TestChangesLoader();
            Reasoner reasoner = TestReasonerUtils.createTestReasoner(initialLoader, (ReasonerStageExecutor)new LoggingStageExecutor());
            reasoner.setAllowIncrementalMode(false);
            for (ElkAxiom axiom : ontology) {
                initialLoader.add(axiom);
            }
            Taxonomy taxonomy = reasoner.getTaxonomy();
            Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)tree).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)greenThing)));
            reasoner.setAllowIncrementalMode(true);
            TestChangesLoader changeLoader = new TestChangesLoader();
            reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
            for (ElkAxiom del : deletions) {
                changeLoader.remove(del);
            }
            taxonomy = reasoner.getTaxonomy();
            Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)tree).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)greenThing)));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFromKangaroo() throws ElkException, IOException {
        InputStream stream = null;
        String toDelete = "Prefix(test:=<http://www.test.com/schema#>) Ontology(\nDisjointClasses(<test:Irrational> <test:Rational>) \n SubClassOf(<test:Kangaroo> <test:Beast>) \n)";
        ElkClass maternityKangaroo = this.objectFactory.getClass((ElkIri)new ElkFullIri("test:MaternityKangaroo"));
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream("incremental/kangaroo.owl");
            List<ElkAxiom> ontology = this.loadAxioms(stream);
            List<ElkAxiom> deletions = this.loadAxioms(new StringReader(toDelete));
            TestChangesLoader initialLoader = new TestChangesLoader();
            Reasoner reasoner = TestReasonerUtils.createTestReasoner(initialLoader, (ReasonerStageExecutor)new LoggingStageExecutor());
            reasoner.setAllowIncrementalMode(false);
            for (ElkAxiom axiom : ontology) {
                initialLoader.add(axiom);
            }
            Taxonomy taxonomy = reasoner.getTaxonomy();
            Assert.assertSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getNode((ElkObject)maternityKangaroo));
            System.out.println("\n\n\n\n========DELETIONS======");
            reasoner.setAllowIncrementalMode(true);
            TestChangesLoader changeLoader = new TestChangesLoader();
            reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
            for (ElkAxiom del : deletions) {
                changeLoader.remove(del);
            }
            taxonomy = reasoner.getTaxonomy();
            Assert.assertNotSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getNode((ElkObject)maternityKangaroo));
            System.out.println("\n\n\n\n========ADDING BACK======");
            reasoner.setAllowIncrementalMode(true);
            reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
            for (ElkAxiom del : deletions) {
                changeLoader.add(del);
            }
            taxonomy = reasoner.getTaxonomy();
            Assert.assertSame((Object)taxonomy.getBottomNode(), (Object)taxonomy.getNode((ElkObject)maternityKangaroo));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    @Test
    public void testDuplicateSubclassAxioms() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)b)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)b)));
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)b)));
    }

    @Test
    public void testPropositionalAdditions() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)c)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)c, (ElkClassExpression)d));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)d));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)b)));
    }

    @Test
    public void testCleanObsoleteContexts() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        TestChangesLoader changeLoader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new PostProcessingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkObjectProperty s = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":S"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":R"));
        ElkSubClassOfAxiom axiom1 = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)s, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b)));
        ElkSubClassOfAxiom axiom2 = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)c, (ElkClassExpression)d);
        ElkSubClassOfAxiom axiom3 = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)c);
        loader.add((ElkAxiom)axiom1).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)c), (ElkClassExpression)c)).add((ElkAxiom)axiom2).add((ElkAxiom)axiom3);
        reasoner.getTaxonomy();
        reasoner.setAllowIncrementalMode(true);
        changeLoader.remove((ElkAxiom)axiom1);
        System.out.println("===========================================");
        reasoner.getTaxonomy();
        changeLoader.remove((ElkAxiom)axiom2).remove((ElkAxiom)axiom3);
        System.out.println("===========================================");
        reasoner.getTaxonomy();
    }

    @Test
    public void testDeleteBinaryDisjointness() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkDisjointClassesAxiom disjBC = this.objectFactory.getDisjointClassesAxiom(Arrays.asList(b, c));
        ElkDisjointClassesAxiom disjCB = this.objectFactory.getDisjointClassesAxiom(Arrays.asList(c, b));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)c)).add((ElkAxiom)disjBC).add((ElkAxiom)disjCB);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)disjCB);
        System.out.println("\n\n\n\n\n===========================================");
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)disjBC);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertFalse((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNaryDisjointness() throws ElkException {
        try {
            TestChangesLoader loader = new TestChangesLoader();
            Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
            reasoner.setAllowIncrementalMode(false);
            ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
            ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
            ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
            ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
            ElkDisjointClassesAxiom disjABCD = this.objectFactory.getDisjointClassesAxiom(Arrays.asList(a, b, c, d));
            ElkDisjointClassesAxiom disjACBD = this.objectFactory.getDisjointClassesAxiom(Arrays.asList(a, c, b, d));
            loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)b)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)c)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)c, (ElkClassExpression)d)).add((ElkAxiom)disjABCD).add((ElkAxiom)disjACBD);
            Taxonomy taxonomy = reasoner.getTaxonomy();
            Assert.assertTrue((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
            reasoner.setAllowIncrementalMode(true);
            TestChangesLoader changeLoader = new TestChangesLoader();
            reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
            changeLoader.remove((ElkAxiom)disjABCD);
            taxonomy = reasoner.getTaxonomy();
            Assert.assertTrue((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
            changeLoader.remove((ElkAxiom)disjACBD);
            reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
            taxonomy = reasoner.getTaxonomy();
            Assert.assertFalse((taxonomy.getNode((ElkObject)a) == taxonomy.getBottomNode() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAddClassRemoveClass() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkClass e = this.objectFactory.getClass((ElkIri)new ElkFullIri(":E"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("R"));
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)c)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)d, (ElkClassExpression)a)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b)));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)d).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)a)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)d, (ElkClassExpression)a)).remove((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b))).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)d, (ElkClassExpression)c)).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)e, (ElkClassExpression)b));
        taxonomy = reasoner.getTaxonomy();
        Assert.assertNull((Object)taxonomy.getNode((ElkObject)a));
        Assert.assertNotNull((Object)taxonomy.getNode((ElkObject)d));
        Assert.assertNotNull((Object)taxonomy.getNode((ElkObject)e));
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)d).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)c)));
    }

    @Test
    public void testPropagations() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":r"));
        ElkSubClassOfAxiom axAsubRsomeB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b));
        ElkSubClassOfAxiom axBsubC = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)c);
        ElkSubClassOfAxiom axRsomeCsubD = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)c), (ElkClassExpression)d);
        loader.add((ElkAxiom)axBsubC).add((ElkAxiom)axRsomeCsubD);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)d).getDirectSubNodes().size());
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)d).getDirectSubNodes().contains(taxonomy.getNode((ElkObject)this.objectFactory.getOwlNothing())));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axAsubRsomeB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)d).getDirectSubNodes().size());
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)d).getDirectSubNodes().contains(taxonomy.getNode((ElkObject)a)));
    }

    @Test
    public void testEquivalences() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        ElkClass x = this.objectFactory.getClass((ElkIri)new ElkFullIri(":X"));
        ElkClass y = this.objectFactory.getClass((ElkIri)new ElkFullIri(":Y"));
        ElkSubClassOfAxiom axXsubY = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)x, (ElkClassExpression)y);
        ElkSubClassOfAxiom axYsubX = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)y, (ElkClassExpression)x);
        loader.add((ElkAxiom)axXsubY);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)1L, (long)taxonomy.getNode((ElkObject)x).getMembers().size());
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axYsubX);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)y).getMembers().size());
    }

    @Test
    public void testEquivalencesPropagations() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), 1);
        reasoner.setAllowIncrementalMode(false);
        ElkClass x = this.objectFactory.getClass((ElkIri)new ElkFullIri(":X"));
        ElkClass y = this.objectFactory.getClass((ElkIri)new ElkFullIri(":Y"));
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":r"));
        ElkEquivalentClassesAxiom axXeqAandRsomeB = this.objectFactory.getEquivalentClassesAxiom((ElkClassExpression)x, (ElkClassExpression)this.objectFactory.getObjectIntersectionOf((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b), new ElkClassExpression[0]), new ElkClassExpression[0]);
        ElkEquivalentClassesAxiom axYeqA = this.objectFactory.getEquivalentClassesAxiom((ElkClassExpression)y, (ElkClassExpression)a, new ElkClassExpression[0]);
        ElkSubClassOfAxiom axYsubRsomeB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)y, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b));
        loader.add((ElkAxiom)axXeqAandRsomeB).add((ElkAxiom)axYeqA);
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)2L, (long)taxonomy.getNode((ElkObject)y).getMembers().size());
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axYsubRsomeB);
        taxonomy = reasoner.getTaxonomy();
        Assert.assertEquals((long)3L, (long)taxonomy.getNode((ElkObject)y).getMembers().size());
    }

    @Test
    public void testDeleteBackwardLinkAndModifySourceContext() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass a = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass b = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass c = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass d = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkClass e = this.objectFactory.getClass((ElkIri)new ElkFullIri(":E"));
        ElkObjectProperty r = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri("R"));
        ElkSubClassOfAxiom toDelete = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)b, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)c));
        ElkSubClassOfAxiom toAdd1 = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)d), (ElkClassExpression)e);
        ElkSubClassOfAxiom toAdd2 = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)c, (ElkClassExpression)d);
        loader.add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)b))).add((ElkAxiom)this.objectFactory.getSubClassOfAxiom((ElkClassExpression)a, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)r, (ElkClassExpression)c))).add((ElkAxiom)toDelete).add((ElkAxiom)this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.objectFactory.getObjectPropertyChain(Arrays.asList(r, r)), (ElkObjectPropertyExpression)r));
        Taxonomy taxonomy = reasoner.getTaxonomy();
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)toDelete).add((ElkAxiom)toAdd1).add((ElkAxiom)toAdd2);
        System.out.println("\n\n\n\n\n");
        taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)a).getDirectSuperNodes().contains(taxonomy.getNode((ElkObject)e)));
    }

    @Test
    public void testDeterministicLinks() throws ElkException, IOException {
        String ontology = "Prefix(:=<http://www.test.com/schema#>) Ontology(\nSubClassOf(:A :B) SubClassOf(:B ObjectSomeValuesFrom(:R :B1)) SubClassOf(:B1 :C1) SubClassOf(ObjectSomeValuesFrom(:R :C1) :F) SubClassOf(:A :C) SubClassOf(:C :E) TransitiveObjectProperty(:R) SubClassOf(:D ObjectSomeValuesFrom(:R :A)) )";
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri("http://www.test.com/schema#A"));
        ElkClass F = this.objectFactory.getClass((ElkIri)new ElkFullIri("http://www.test.com/schema#F"));
        List<ElkAxiom> axioms = this.loadAxioms(new StringReader(ontology));
        TestChangesLoader initialLoader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(initialLoader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        for (ElkAxiom axiom : axioms) {
            initialLoader.add(axiom);
        }
        Taxonomy taxonomy = reasoner.getTaxonomy();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)A).getAllSuperNodes().contains(taxonomy.getNode((ElkObject)F)));
        System.out.println("\n\n\n\n===========================================");
        String toAdd = "Prefix(:=<http://www.test.com/schema#>) Ontology(\nSubClassOf(:C1 :B1) SubClassOf(:C ObjectSomeValuesFrom(:R :C1)) )";
        List<ElkAxiom> additions = this.loadAxioms(new StringReader(toAdd));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        for (ElkAxiom axiom : additions) {
            changeLoader.add(axiom);
        }
        taxonomy = reasoner.getTaxonomy();
        System.out.println("\n\n\n\n===========================================");
        String toDelete = "Prefix(:=<http://www.test.com/schema#>) Ontology(\nSubClassOf(:C :E) )";
        List<ElkAxiom> deletions = this.loadAxioms(new StringReader(toDelete));
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        for (ElkAxiom axiom : deletions) {
            changeLoader.remove(axiom);
        }
        taxonomy = reasoner.getTaxonomy();
        System.out.println("\n\n\n\n===========================================");
        toDelete = "Prefix(:=<http://www.test.com/schema#>) Ontology(\nSubClassOf(:D ObjectSomeValuesFrom(:R :A)) )";
        deletions = this.loadAxioms(new StringReader(toDelete));
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        for (ElkAxiom axiom : deletions) {
            changeLoader.remove(axiom);
        }
        taxonomy = reasoner.getTaxonomy();
    }

    private List<ElkAxiom> loadAxioms(InputStream stream) throws IOException, Owl2ParseException {
        return this.loadAxioms(new InputStreamReader(stream));
    }

    private List<ElkAxiom> loadAxioms(Reader reader) throws IOException, Owl2ParseException {
        Owl2Parser parser = new Owl2FunctionalStyleParserFactory().getParser(reader);
        final ArrayList<ElkAxiom> axioms = new ArrayList<ElkAxiom>();
        parser.accept(new Owl2ParserAxiomProcessor(){

            public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
            }

            public void visit(ElkAxiom elkAxiom) throws Owl2ParseException {
                axioms.add(elkAxiom);
            }

            public void finish() throws Owl2ParseException {
            }
        });
        return axioms;
    }
}

