/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.stages.PostProcessingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;

public class LowLevelIncrementalABoxTest {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    @Test
    public void testBasicDeletion() throws ElkException, IOException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass C = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkNamedIndividual ind = this.objectFactory.getNamedIndividual((ElkIri)new ElkFullIri(":in"));
        ElkClassAssertionAxiom axiInstA = this.objectFactory.getClassAssertionAxiom((ElkClassExpression)A, (ElkIndividual)ind);
        ElkSubClassOfAxiom axASubB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B);
        ElkSubClassOfAxiom axCSubB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)C, (ElkClassExpression)B);
        loader.add((ElkAxiom)axiInstA).add((ElkAxiom)axASubB).add((ElkAxiom)axCSubB);
        InstanceTaxonomy taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)ind)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axASubB);
        taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertFalse((boolean)taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)ind)));
    }

    @Test
    public void testInvalidTaxonomyAfterInconsistency() throws ElkException, IOException {
        TestChangesLoader loader = new TestChangesLoader();
        TestChangesLoader changeLoader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkNamedIndividual ind = this.objectFactory.getNamedIndividual((ElkIri)new ElkFullIri(":in"));
        ElkClassAssertionAxiom axiInstA = this.objectFactory.getClassAssertionAxiom((ElkClassExpression)A, (ElkIndividual)ind);
        ElkSubClassOfAxiom axTopSubB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getOwlThing(), (ElkClassExpression)B);
        ElkDisjointClassesAxiom axDisj = this.objectFactory.getDisjointClassesAxiom((ElkClassExpression)A, (ElkClassExpression)B, new ElkClassExpression[0]);
        loader.add((ElkAxiom)axiInstA).add((ElkAxiom)axTopSubB).add((ElkAxiom)axDisj);
        reasoner.getInstanceTaxonomyQuietly();
        reasoner.setAllowIncrementalMode(true);
        changeLoader.remove((ElkAxiom)axTopSubB);
        reasoner.getInstanceTaxonomyQuietly();
        changeLoader.add((ElkAxiom)axTopSubB);
        reasoner.getInstanceTaxonomyQuietly();
        changeLoader.remove((ElkAxiom)axDisj);
        reasoner.getInstanceTaxonomyQuietly();
    }

    @Test
    public void testRemoveIndividual() throws ElkException, IOException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkNamedIndividual ind = this.objectFactory.getNamedIndividual((ElkIri)new ElkFullIri(":in"));
        ElkClassAssertionAxiom axiInstA = this.objectFactory.getClassAssertionAxiom((ElkClassExpression)A, (ElkIndividual)ind);
        ElkSubClassOfAxiom axASubB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B);
        loader.add((ElkAxiom)axiInstA).add((ElkAxiom)axASubB);
        InstanceTaxonomy taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().size() == 1 ? 1 : 0) != 0);
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.remove((ElkAxiom)axiInstA);
        taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes().isEmpty());
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().isEmpty());
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axiInstA);
        taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)ind)));
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)ind)));
    }

    @Test
    public void testNewIndividual() throws ElkException, IOException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkNamedIndividual ind = this.objectFactory.getNamedIndividual((ElkIri)new ElkFullIri(":in"));
        ElkNamedIndividual newInd = this.objectFactory.getNamedIndividual((ElkIri)new ElkFullIri(":new"));
        ElkClassAssertionAxiom axiInstA = this.objectFactory.getClassAssertionAxiom((ElkClassExpression)A, (ElkIndividual)ind);
        ElkClassAssertionAxiom axNewInstB = this.objectFactory.getClassAssertionAxiom((ElkClassExpression)B, (ElkIndividual)newInd);
        ElkSubClassOfAxiom axASubB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)B);
        loader.add((ElkAxiom)axiInstA).add((ElkAxiom)axASubB);
        InstanceTaxonomy taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().size() == 1 ? 1 : 0) != 0);
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axNewInstB);
        taxonomy = reasoner.getInstanceTaxonomyQuietly();
        Assert.assertTrue((taxonomy.getTypeNode((ElkObject)A).getDirectInstanceNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)B).getAllInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)ind)));
        Assert.assertTrue((boolean)taxonomy.getTypeNode((ElkObject)B).getDirectInstanceNodes().contains(taxonomy.getInstanceNode((ElkObject)newInd)));
    }
}

