/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.PostProcessingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;

public class IncrementalModeSwitchTest {
    final ElkObjectFactory objectFactory = new ElkObjectFactoryImpl();

    @Test
    public void testAddedTransitivity() throws ElkException {
        TestChangesLoader loader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(loader, (ReasonerStageExecutor)new PostProcessingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        ElkClass A = this.objectFactory.getClass((ElkIri)new ElkFullIri(":A"));
        ElkClass B = this.objectFactory.getClass((ElkIri)new ElkFullIri(":B"));
        ElkClass C = this.objectFactory.getClass((ElkIri)new ElkFullIri(":C"));
        ElkClass D = this.objectFactory.getClass((ElkIri)new ElkFullIri(":D"));
        ElkObjectProperty R = this.objectFactory.getObjectProperty((ElkIri)new ElkFullIri(":R"));
        ElkSubClassOfAxiom axASubRB = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)A, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)B));
        ElkSubClassOfAxiom axBSubRC = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)B, (ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)C));
        ElkSubClassOfAxiom axRCSubD = this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)R, (ElkClassExpression)C), (ElkClassExpression)D);
        ElkTransitiveObjectPropertyAxiom axTransR = this.objectFactory.getTransitiveObjectPropertyAxiom((ElkObjectPropertyExpression)R);
        loader.add((ElkAxiom)axASubRB).add((ElkAxiom)axBSubRC).add((ElkAxiom)axRCSubD);
        Taxonomy taxonomy = reasoner.getTaxonomyQuietly();
        Assert.assertFalse((boolean)taxonomy.getNode((ElkObject)A).getAllSuperNodes().contains(taxonomy.getNode((ElkObject)D)));
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        changeLoader.add((ElkAxiom)axTransR);
        taxonomy = reasoner.getTaxonomyQuietly();
        Assert.assertTrue((boolean)taxonomy.getNode((ElkObject)A).getAllSuperNodes().contains(taxonomy.getNode((ElkObject)D)));
    }

    @Test
    public void testSwitchDueToNewRole() throws ElkException, IOException {
        String toAdd = "Prefix( : = <http://example.org/> ) Prefix( owl: = <http://www.w3.org/2002/07/owl#> ) Ontology(\nSubClassOf(:C ObjectSomeValuesFrom(:T :B)) \nObjectPropertyDomain(:T owl:Nothing) \n)";
        String initial = "Prefix( : = <http://example.org/> )\nPrefix( owl: = <http://www.w3.org/2002/07/owl#> ) \nOntology( \nEquivalentClasses(:A :C) \n SubClassOf(owl:Thing ObjectSomeValuesFrom(:R :B)) \n SubClassOf(ObjectSomeValuesFrom(:S :B) :A) \nSubObjectPropertyOf(:R :S) )";
        List<ElkAxiom> ontology = this.loadAxioms(new StringReader(initial));
        List<ElkAxiom> additions = this.loadAxioms(new StringReader(toAdd));
        TestChangesLoader initialLoader = new TestChangesLoader();
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(initialLoader, (ReasonerStageExecutor)new LoggingStageExecutor());
        reasoner.setAllowIncrementalMode(false);
        for (ElkAxiom axiom : ontology) {
            initialLoader.add(axiom);
        }
        Assert.assertFalse((boolean)reasoner.isInconsistent());
        reasoner.getTaxonomy();
        System.out.println("===========================================");
        reasoner.setAllowIncrementalMode(true);
        TestChangesLoader changeLoader = new TestChangesLoader();
        reasoner.registerAxiomLoader((AxiomLoader)changeLoader);
        for (ElkAxiom add : additions) {
            changeLoader.add(add);
        }
        Assert.assertTrue((boolean)reasoner.isInconsistent());
    }

    private List<ElkAxiom> loadAxioms(Reader reader) throws IOException, Owl2ParseException {
        Owl2Parser parser = new Owl2FunctionalStyleParserFactory().getParser(reader);
        final ArrayList<ElkAxiom> axioms = new ArrayList<ElkAxiom>();
        parser.accept(new Owl2ParserAxiomProcessor(){

            public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
            }

            public void visit(ElkAxiom elkAxiom) throws Owl2ParseException {
                axioms.add(elkAxiom);
            }

            public void finish() throws Owl2ParseException {
            }
        });
        return axioms;
    }
}

