/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.junit.runner.RunWith;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.parsing.Owl2ParseException;
import org.semanticweb.elk.owl.parsing.Owl2Parser;
import org.semanticweb.elk.owl.parsing.Owl2ParserAxiomProcessor;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.ClassTaxonomyTestOutput;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasoningTestManifest;
import org.semanticweb.elk.reasoner.TestReasonerUtils;
import org.semanticweb.elk.reasoner.incremental.BaseIncrementalClassificationCorrectnessTest;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangeType;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.stages.PostProcessingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.testing.PolySuite;

@RunWith(value=PolySuite.class)
public class IncrementalClassificationCorrectnessTest
extends BaseIncrementalClassificationCorrectnessTest<ElkAxiom> {
    public IncrementalClassificationCorrectnessTest(ReasoningTestManifest<ClassTaxonomyTestOutput, ClassTaxonomyTestOutput> testManifest) {
        super(testManifest);
    }

    @Override
    protected void applyChanges(Reasoner reasoner, Iterable<ElkAxiom> changes, IncrementalChangeType type) {
        reasoner.registerAxiomLoader((AxiomLoader)new TestChangesLoader(changes, type));
    }

    @Override
    protected void dumpChangeToLog(ElkAxiom change, Level level) {
        LOGGER_.log((Priority)level, (Object)(OwlFunctionalStylePrinter.toString((ElkObject)change) + ": deleted"));
    }

    @Override
    protected void loadAxioms(InputStream stream, List<ElkAxiom> staticAxioms, final OnOffVector<ElkAxiom> changingAxioms) throws IOException, Owl2ParseException {
        Owl2Parser parser = new Owl2FunctionalStyleParserFactory().getParser(stream);
        parser.accept(new Owl2ParserAxiomProcessor(){

            public void visit(ElkPrefix elkPrefix) throws Owl2ParseException {
            }

            public void visit(ElkAxiom elkAxiom) throws Owl2ParseException {
                changingAxioms.add(elkAxiom);
            }

            public void finish() throws Owl2ParseException {
            }
        });
    }

    @Override
    protected Reasoner getReasoner(Iterable<ElkAxiom> axioms) {
        Reasoner reasoner = TestReasonerUtils.createTestReasoner(new TestChangesLoader(axioms, IncrementalChangeType.ADD), (ReasonerStageExecutor)new PostProcessingStageExecutor());
        return reasoner;
    }
}

