/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Random;
import org.semanticweb.elk.RandomSeedProvider;
import org.semanticweb.elk.reasoner.incremental.IncrementalChange;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;

public class IncrementalChangeTracker<T> {
    private final OnOffVector<T> changingAxioms_;
    private final Deque<IncrementalChange<T>> changes_ = new LinkedList<IncrementalChange<T>>();
    private final int changeSize_;
    private final Random rnd_ = new Random(RandomSeedProvider.VALUE);

    public IncrementalChangeTracker(OnOffVector<T> changingAxioms, int changeSize) {
        this.changeSize_ = changeSize;
        this.changingAxioms_ = changingAxioms;
    }

    public IncrementalChange<T> generateNextChange() {
        IncrementalChange change = new IncrementalChange();
        for (int i = 0; i < this.changeSize_; ++i) {
            int index = this.rnd_.nextInt(this.changingAxioms_.size());
            Object axiom = this.changingAxioms_.get(index);
            if (this.changingAxioms_.flipOnOff(index)) {
                change.registerDeletion(axiom);
                continue;
            }
            change.registerAddition(axiom);
        }
        this.changes_.add(change);
        return change;
    }

    Deque<IncrementalChange<T>> getChangeHistory() {
        return this.changes_;
    }

    int getChangeSize() {
        return this.changeSize_;
    }

    void clearHistory() {
        this.changes_.clear();
    }
}

