/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IncrementalChange<T> {
    private final List<T> additions_;
    private final List<T> deletions_;

    public IncrementalChange(List<T> additions, List<T> deletions) {
        this.additions_ = additions;
        this.deletions_ = deletions;
    }

    public IncrementalChange() {
        this(new ArrayList(), new ArrayList());
    }

    public void clear() {
        this.additions_.clear();
        this.deletions_.clear();
    }

    public List<T> getAdditions() {
        return Collections.unmodifiableList(this.additions_);
    }

    public List<T> getDeletions() {
        return Collections.unmodifiableList(this.deletions_);
    }

    public void registerAddition(T axiom) {
        this.additions_.add(axiom);
    }

    public void registerDeletion(T axiom) {
        this.deletions_.add(axiom);
    }
}

