/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;
import org.semanticweb.elk.reasoner.incremental.RandomWalkTestHook;
import org.semanticweb.elk.reasoner.incremental.TestChangesLoader;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.util.collections.Operations;

public class CleanIndexHook
implements RandomWalkTestHook {
    private static final Logger LOGGER_ = Logger.getLogger(CleanIndexHook.class);

    @Override
    public void apply(Reasoner reasoner, OnOffVector<ElkAxiom> changingAxioms, List<ElkAxiom> staticAxioms) throws ElkException {
        CleanIndexHook.clearIndexTest(reasoner, Operations.concat(changingAxioms.getOnElements(), staticAxioms));
    }

    public static void clearIndexTest(Reasoner reasoner, Iterable<ElkAxiom> axioms) throws ElkException {
        int size = CleanIndexHook.getIndexSize(reasoner);
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("initial size is " + size));
        }
        TestChangesLoader loader = new TestChangesLoader();
        for (ElkAxiom axiom : axioms) {
            if (!(axiom instanceof ElkClassAxiom) && !(axiom instanceof ElkObjectPropertyDomainAxiom)) continue;
            loader.remove(axiom);
        }
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)"Cleaning the index...");
        }
        reasoner.registerAxiomLoader((AxiomLoader)loader);
        reasoner.setAllowIncrementalMode(false);
        reasoner.getTaxonomyQuietly();
        int cnt = CleanIndexHook.getIndexSize(reasoner);
        if (cnt > 2) {
            LOGGER_.error((Object)("index must be empty but its size is " + cnt));
        }
        for (ElkAxiom axiom : axioms) {
            if (!(axiom instanceof ElkClassAxiom) && !(axiom instanceof ElkObjectPropertyDomainAxiom)) continue;
            loader.add(axiom);
        }
        reasoner.registerAxiomLoader((AxiomLoader)loader);
        reasoner.getTaxonomyQuietly();
        cnt = CleanIndexHook.getIndexSize(reasoner);
        if (cnt != size) {
            LOGGER_.error((Object)("index size must be " + size + " but is " + cnt));
        }
        reasoner.setAllowIncrementalMode(true);
    }

    private static int getIndexSize(Reasoner reasoner) {
        int cnt = 0;
        for (IndexedClassExpression ice : reasoner.getIndexedClassExpressions()) {
            ++cnt;
            LOGGER_.trace((Object)("indexed CE: " + ice + " " + ice.printOccurrenceNumbers()));
        }
        if (reasoner.getIndexedClassExpressions().size() != cnt) {
            LOGGER_.error((Object)("Index size mismatch: " + reasoner.getIndexedClassExpressions().size() + "!=" + cnt));
        }
        return cnt;
    }
}

