/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.incremental.OnOffVector;

public class ClassAxiomTrackingLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    protected final AxiomLoader loader_;
    protected final OnOffVector<ElkAxiom> changingAxioms_;
    protected final List<ElkAxiom> staticAxioms_;

    public ClassAxiomTrackingLoader(AxiomLoader loader, OnOffVector<ElkAxiom> trackedAxioms, List<ElkAxiom> untrackedAxioms) {
        this.loader_ = loader;
        this.changingAxioms_ = trackedAxioms;
        this.staticAxioms_ = untrackedAxioms;
    }

    ClassAxiomTrackingLoader(AxiomLoader loader) {
        this(loader, new OnOffVector<ElkAxiom>(127), new ArrayList<ElkAxiom>());
    }

    public OnOffVector<ElkAxiom> getChangingAxioms() {
        return this.changingAxioms_;
    }

    public List<ElkAxiom> getStaticAxioms() {
        return this.staticAxioms_;
    }

    public void load(final ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        ElkAxiomProcessor wrappedAxiomInserter = new ElkAxiomProcessor(){

            public void visit(ElkAxiom elkAxiom) {
                axiomInserter.visit(elkAxiom);
                if (elkAxiom instanceof ElkClassAxiom) {
                    ClassAxiomTrackingLoader.this.changingAxioms_.add(elkAxiom);
                } else {
                    ClassAxiomTrackingLoader.this.staticAxioms_.add(elkAxiom);
                }
            }
        };
        this.loader_.load(wrappedAxiomInserter, axiomDeleter);
    }

    public boolean isLoadingFinished() {
        return this.loader_.isLoadingFinished();
    }

    public void dispose() {
        this.loader_.dispose();
    }
}

